// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreatePresignedDomainUrlRequest private constructor(builder: Builder) {
    /**
     * The domain ID.
     */
    public val domainId: kotlin.String? = builder.domainId
    /**
     * The number of seconds until the pre-signed URL expires. This value defaults to 300.
     */
    public val expiresInSeconds: kotlin.Int? = builder.expiresInSeconds
    /**
     * The landing page that the user is directed to when accessing the presigned URL. Using this value, users can access Studio or Studio Classic, even if it is not the default experience for the domain. The supported values are:
     * + `studio::relative/path`: Directs users to the relative path in Studio.
     * + `app:JupyterServer:relative/path`: Directs users to the relative path in the Studio Classic application.
     * + `app:JupyterLab:relative/path`: Directs users to the relative path in the JupyterLab application.
     * + `app:RStudioServerPro:relative/path`: Directs users to the relative path in the RStudio application.
     * + `app:CodeEditor:relative/path`: Directs users to the relative path in the Code Editor, based on Code-OSS, Visual Studio Code - Open Source application.
     * + `app:Canvas:relative/path`: Directs users to the relative path in the Canvas application.
     */
    public val landingUri: kotlin.String? = builder.landingUri
    /**
     * The session expiration duration in seconds. This value defaults to 43200.
     */
    public val sessionExpirationDurationInSeconds: kotlin.Int? = builder.sessionExpirationDurationInSeconds
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String? = builder.spaceName
    /**
     * The name of the UserProfile to sign-in as.
     */
    public val userProfileName: kotlin.String? = builder.userProfileName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreatePresignedDomainUrlRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePresignedDomainUrlRequest(")
        append("domainId=$domainId,")
        append("expiresInSeconds=$expiresInSeconds,")
        append("landingUri=$landingUri,")
        append("sessionExpirationDurationInSeconds=$sessionExpirationDurationInSeconds,")
        append("spaceName=$spaceName,")
        append("userProfileName=$userProfileName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainId?.hashCode() ?: 0
        result = 31 * result + (expiresInSeconds ?: 0)
        result = 31 * result + (landingUri?.hashCode() ?: 0)
        result = 31 * result + (sessionExpirationDurationInSeconds ?: 0)
        result = 31 * result + (spaceName?.hashCode() ?: 0)
        result = 31 * result + (userProfileName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePresignedDomainUrlRequest

        if (domainId != other.domainId) return false
        if (expiresInSeconds != other.expiresInSeconds) return false
        if (landingUri != other.landingUri) return false
        if (sessionExpirationDurationInSeconds != other.sessionExpirationDurationInSeconds) return false
        if (spaceName != other.spaceName) return false
        if (userProfileName != other.userProfileName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreatePresignedDomainUrlRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The domain ID.
         */
        public var domainId: kotlin.String? = null
        /**
         * The number of seconds until the pre-signed URL expires. This value defaults to 300.
         */
        public var expiresInSeconds: kotlin.Int? = null
        /**
         * The landing page that the user is directed to when accessing the presigned URL. Using this value, users can access Studio or Studio Classic, even if it is not the default experience for the domain. The supported values are:
         * + `studio::relative/path`: Directs users to the relative path in Studio.
         * + `app:JupyterServer:relative/path`: Directs users to the relative path in the Studio Classic application.
         * + `app:JupyterLab:relative/path`: Directs users to the relative path in the JupyterLab application.
         * + `app:RStudioServerPro:relative/path`: Directs users to the relative path in the RStudio application.
         * + `app:CodeEditor:relative/path`: Directs users to the relative path in the Code Editor, based on Code-OSS, Visual Studio Code - Open Source application.
         * + `app:Canvas:relative/path`: Directs users to the relative path in the Canvas application.
         */
        public var landingUri: kotlin.String? = null
        /**
         * The session expiration duration in seconds. This value defaults to 43200.
         */
        public var sessionExpirationDurationInSeconds: kotlin.Int? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null
        /**
         * The name of the UserProfile to sign-in as.
         */
        public var userProfileName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreatePresignedDomainUrlRequest) : this() {
            this.domainId = x.domainId
            this.expiresInSeconds = x.expiresInSeconds
            this.landingUri = x.landingUri
            this.sessionExpirationDurationInSeconds = x.sessionExpirationDurationInSeconds
            this.spaceName = x.spaceName
            this.userProfileName = x.userProfileName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreatePresignedDomainUrlRequest = CreatePresignedDomainUrlRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
