// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A list of continuous hyperparameters to tune.
 */
public class ContinuousParameterRange private constructor(builder: Builder) {
    /**
     * The maximum value for the hyperparameter. The tuning job uses floating-point values between `MinValue` value and this value for tuning.
     */
    public val maxValue: kotlin.String? = builder.maxValue
    /**
     * The minimum value for the hyperparameter. The tuning job uses floating-point values between this value and `MaxValue`for tuning.
     */
    public val minValue: kotlin.String? = builder.minValue
    /**
     * The name of the continuous hyperparameter to tune.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see [Hyperparameter Scaling](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type). One of the following values:
     *
     * ## Auto
     * SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
     *
     * ## Linear
     * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     *
     * ## Logarithmic
     * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     *
     * Logarithmic scaling works only for ranges that have only values greater than 0.
     *
     * ## ReverseLogarithmic
     * Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.
     *
     * Reverse logarithmic scaling works only for ranges that are entirely within the range 0<=x<1.0.
     */
    public val scalingType: aws.sdk.kotlin.services.sagemaker.model.HyperParameterScalingType? = builder.scalingType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ContinuousParameterRange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContinuousParameterRange(")
        append("maxValue=$maxValue,")
        append("minValue=$minValue,")
        append("name=$name,")
        append("scalingType=$scalingType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxValue?.hashCode() ?: 0
        result = 31 * result + (minValue?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scalingType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContinuousParameterRange

        if (maxValue != other.maxValue) return false
        if (minValue != other.minValue) return false
        if (name != other.name) return false
        if (scalingType != other.scalingType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ContinuousParameterRange = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum value for the hyperparameter. The tuning job uses floating-point values between `MinValue` value and this value for tuning.
         */
        public var maxValue: kotlin.String? = null
        /**
         * The minimum value for the hyperparameter. The tuning job uses floating-point values between this value and `MaxValue`for tuning.
         */
        public var minValue: kotlin.String? = null
        /**
         * The name of the continuous hyperparameter to tune.
         */
        public var name: kotlin.String? = null
        /**
         * The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see [Hyperparameter Scaling](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type). One of the following values:
         *
         * ## Auto
         * SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
         *
         * ## Linear
         * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         *
         * ## Logarithmic
         * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         *
         * Logarithmic scaling works only for ranges that have only values greater than 0.
         *
         * ## ReverseLogarithmic
         * Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.
         *
         * Reverse logarithmic scaling works only for ranges that are entirely within the range 0<=x<1.0.
         */
        public var scalingType: aws.sdk.kotlin.services.sagemaker.model.HyperParameterScalingType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ContinuousParameterRange) : this() {
            this.maxValue = x.maxValue
            this.minValue = x.minValue
            this.name = x.name
            this.scalingType = x.scalingType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ContinuousParameterRange = ContinuousParameterRange(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
