// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies the type and size of the endpoint capacity to activate for a blue/green deployment, a rolling deployment, or a rollback strategy. You can specify your batches as either instance count or the overall percentage or your fleet.
 *
 * For a rollback strategy, if you don't specify the fields in this object, or if you set the `Value` to 100%, then SageMaker uses a blue/green rollback strategy and rolls all traffic back to the blue fleet.
 */
public class CapacitySize private constructor(builder: Builder) {
    /**
     * Specifies the endpoint capacity type.
     * + `INSTANCE_COUNT`: The endpoint activates based on the number of instances.
     * + `CAPACITY_PERCENT`: The endpoint activates based on the specified percentage of capacity.
     */
    public val type: aws.sdk.kotlin.services.sagemaker.model.CapacitySizeType? = builder.type
    /**
     * Defines the capacity size, either as a number of instances or a capacity percentage.
     */
    public val value: kotlin.Int? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CapacitySize = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacitySize(")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (value ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacitySize

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CapacitySize = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the endpoint capacity type.
         * + `INSTANCE_COUNT`: The endpoint activates based on the number of instances.
         * + `CAPACITY_PERCENT`: The endpoint activates based on the specified percentage of capacity.
         */
        public var type: aws.sdk.kotlin.services.sagemaker.model.CapacitySizeType? = null
        /**
         * Defines the capacity size, either as a number of instances or a capacity percentage.
         */
        public var value: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CapacitySize) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CapacitySize = CapacitySize(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
