// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A list of container definitions that describe the different containers that make up an AutoML candidate. For more information, see [ ContainerDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html).
 */
public class AutoMlContainerDefinition private constructor(builder: Builder) {
    /**
     * The environment variables to set in the container. For more information, see [ ContainerDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html).
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * The Amazon Elastic Container Registry (Amazon ECR) path of the container. For more information, see [ ContainerDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html).
     */
    public val image: kotlin.String? = builder.image
    /**
     * The location of the model artifacts. For more information, see [ ContainerDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html).
     */
    public val modelDataUrl: kotlin.String? = builder.modelDataUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlContainerDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlContainerDefinition(")
        append("environment=$environment,")
        append("image=$image,")
        append("modelDataUrl=$modelDataUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = environment?.hashCode() ?: 0
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (modelDataUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlContainerDefinition

        if (environment != other.environment) return false
        if (image != other.image) return false
        if (modelDataUrl != other.modelDataUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlContainerDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The environment variables to set in the container. For more information, see [ ContainerDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html).
         */
        public var environment: Map<String, String>? = null
        /**
         * The Amazon Elastic Container Registry (Amazon ECR) path of the container. For more information, see [ ContainerDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html).
         */
        public var image: kotlin.String? = null
        /**
         * The location of the model artifacts. For more information, see [ ContainerDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html).
         */
        public var modelDataUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlContainerDefinition) : this() {
            this.environment = x.environment
            this.image = x.image
            this.modelDataUrl = x.modelDataUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlContainerDefinition = AutoMlContainerDefinition(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
