// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A structure of additional Inference Specification. Additional Inference Specification specifies details about inference jobs that can be run with models based on this model package
 */
public class AdditionalInferenceSpecificationDefinition private constructor(builder: Builder) {
    /**
     * The Amazon ECR registry path of the Docker image that contains the inference code.
     */
    public val containers: List<ModelPackageContainerDefinition>? = builder.containers
    /**
     * A description of the additional Inference specification
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique name to identify the additional inference specification. The name must be unique within the list of your additional inference specifications for a particular model package.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The supported MIME types for the input data.
     */
    public val supportedContentTypes: List<String>? = builder.supportedContentTypes
    /**
     * A list of the instance types that are used to generate inferences in real-time.
     */
    public val supportedRealtimeInferenceInstanceTypes: List<ProductionVariantInstanceType>? = builder.supportedRealtimeInferenceInstanceTypes
    /**
     * The supported MIME types for the output data.
     */
    public val supportedResponseMimeTypes: List<String>? = builder.supportedResponseMimeTypes
    /**
     * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
     */
    public val supportedTransformInstanceTypes: List<TransformInstanceType>? = builder.supportedTransformInstanceTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AdditionalInferenceSpecificationDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdditionalInferenceSpecificationDefinition(")
        append("containers=$containers,")
        append("description=$description,")
        append("name=$name,")
        append("supportedContentTypes=$supportedContentTypes,")
        append("supportedRealtimeInferenceInstanceTypes=$supportedRealtimeInferenceInstanceTypes,")
        append("supportedResponseMimeTypes=$supportedResponseMimeTypes,")
        append("supportedTransformInstanceTypes=$supportedTransformInstanceTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (supportedContentTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedRealtimeInferenceInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedResponseMimeTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedTransformInstanceTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdditionalInferenceSpecificationDefinition

        if (containers != other.containers) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (supportedContentTypes != other.supportedContentTypes) return false
        if (supportedRealtimeInferenceInstanceTypes != other.supportedRealtimeInferenceInstanceTypes) return false
        if (supportedResponseMimeTypes != other.supportedResponseMimeTypes) return false
        if (supportedTransformInstanceTypes != other.supportedTransformInstanceTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AdditionalInferenceSpecificationDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         */
        public var containers: List<ModelPackageContainerDefinition>? = null
        /**
         * A description of the additional Inference specification
         */
        public var description: kotlin.String? = null
        /**
         * A unique name to identify the additional inference specification. The name must be unique within the list of your additional inference specifications for a particular model package.
         */
        public var name: kotlin.String? = null
        /**
         * The supported MIME types for the input data.
         */
        public var supportedContentTypes: List<String>? = null
        /**
         * A list of the instance types that are used to generate inferences in real-time.
         */
        public var supportedRealtimeInferenceInstanceTypes: List<ProductionVariantInstanceType>? = null
        /**
         * The supported MIME types for the output data.
         */
        public var supportedResponseMimeTypes: List<String>? = null
        /**
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
         */
        public var supportedTransformInstanceTypes: List<TransformInstanceType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AdditionalInferenceSpecificationDefinition) : this() {
            this.containers = x.containers
            this.description = x.description
            this.name = x.name
            this.supportedContentTypes = x.supportedContentTypes
            this.supportedRealtimeInferenceInstanceTypes = x.supportedRealtimeInferenceInstanceTypes
            this.supportedResponseMimeTypes = x.supportedResponseMimeTypes
            this.supportedTransformInstanceTypes = x.supportedTransformInstanceTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AdditionalInferenceSpecificationDefinition = AdditionalInferenceSpecificationDefinition(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
