// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.ImportHubContentResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportHubContentOperationDeserializer: HttpDeserialize<ImportHubContentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ImportHubContentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwImportHubContentError(context, call)
        }
        val builder = ImportHubContentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeImportHubContentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwImportHubContentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceInUse" -> ResourceInUseDeserializer().deserialize(context, wrappedCall)
        "ResourceLimitExceeded" -> ResourceLimitExceededDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeImportHubContentOperationBody(builder: ImportHubContentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HUBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubArn"))
    val HUBCONTENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HUBARN_DESCRIPTOR)
        field(HUBCONTENTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HUBARN_DESCRIPTOR.index -> builder.hubArn = deserializeString()
                HUBCONTENTARN_DESCRIPTOR.index -> builder.hubContentArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
