// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.DescribeSpaceResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.SpaceSettings
import aws.sdk.kotlin.services.sagemaker.model.SpaceStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeSpaceOperationDeserializer: HttpDeserialize<DescribeSpaceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeSpaceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeSpaceError(context, call)
        }
        val builder = DescribeSpaceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSpaceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeSpaceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSpaceOperationBody(builder: DescribeSpaceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainId"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HOMEEFSFILESYSTEMUID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HomeEfsFileSystemUid"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val SPACEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SpaceArn"))
    val SPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SpaceName"))
    val SPACESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SpaceSettings"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HOMEEFSFILESYSTEMUID_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(SPACEARN_DESCRIPTOR)
        field(SPACENAME_DESCRIPTOR)
        field(SPACESETTINGS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HOMEEFSFILESYSTEMUID_DESCRIPTOR.index -> builder.homeEfsFileSystemUid = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SPACEARN_DESCRIPTOR.index -> builder.spaceArn = deserializeString()
                SPACENAME_DESCRIPTOR.index -> builder.spaceName = deserializeString()
                SPACESETTINGS_DESCRIPTOR.index -> builder.spaceSettings = deserializeSpaceSettingsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SpaceStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
