// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.DescribeProjectResponse
import aws.sdk.kotlin.services.sagemaker.model.ProjectStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails
import aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisioningDetails
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeProjectOperationDeserializer: HttpDeserialize<DescribeProjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeProjectResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeProjectError(context, call)
        }
        val builder = DescribeProjectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProjectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProjectError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProjectOperationBody(builder: DescribeProjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val PROJECTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProjectArn"))
    val PROJECTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProjectDescription"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProjectId"))
    val PROJECTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProjectName"))
    val PROJECTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ProjectStatus"))
    val SERVICECATALOGPROVISIONEDPRODUCTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ServiceCatalogProvisionedProductDetails"))
    val SERVICECATALOGPROVISIONINGDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ServiceCatalogProvisioningDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(PROJECTARN_DESCRIPTOR)
        field(PROJECTDESCRIPTION_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
        field(PROJECTNAME_DESCRIPTOR)
        field(PROJECTSTATUS_DESCRIPTOR)
        field(SERVICECATALOGPROVISIONEDPRODUCTDETAILS_DESCRIPTOR)
        field(SERVICECATALOGPROVISIONINGDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                PROJECTARN_DESCRIPTOR.index -> builder.projectArn = deserializeString()
                PROJECTDESCRIPTION_DESCRIPTOR.index -> builder.projectDescription = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                PROJECTNAME_DESCRIPTOR.index -> builder.projectName = deserializeString()
                PROJECTSTATUS_DESCRIPTOR.index -> builder.projectStatus = deserializeString().let { ProjectStatus.fromValue(it) }
                SERVICECATALOGPROVISIONEDPRODUCTDETAILS_DESCRIPTOR.index -> builder.serviceCatalogProvisionedProductDetails = deserializeServiceCatalogProvisionedProductDetailsDocument(deserializer)
                SERVICECATALOGPROVISIONINGDETAILS_DESCRIPTOR.index -> builder.serviceCatalogProvisioningDetails = deserializeServiceCatalogProvisioningDetailsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
