// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse
import aws.sdk.kotlin.services.sagemaker.model.ModelExplainabilityAppSpecification
import aws.sdk.kotlin.services.sagemaker.model.ModelExplainabilityBaselineConfig
import aws.sdk.kotlin.services.sagemaker.model.ModelExplainabilityJobInput
import aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringResources
import aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeModelExplainabilityJobDefinitionOperationDeserializer: HttpDeserialize<DescribeModelExplainabilityJobDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeModelExplainabilityJobDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeModelExplainabilityJobDefinitionError(context, call)
        }
        val builder = DescribeModelExplainabilityJobDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeModelExplainabilityJobDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeModelExplainabilityJobDefinitionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeModelExplainabilityJobDefinitionOperationBody(builder: DescribeModelExplainabilityJobDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val JOBDEFINITIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDefinitionArn"))
    val JOBDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDefinitionName"))
    val JOBRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JobResources"))
    val MODELEXPLAINABILITYAPPSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelExplainabilityAppSpecification"))
    val MODELEXPLAINABILITYBASELINECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelExplainabilityBaselineConfig"))
    val MODELEXPLAINABILITYJOBINPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelExplainabilityJobInput"))
    val MODELEXPLAINABILITYJOBOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelExplainabilityJobOutputConfig"))
    val NETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NetworkConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(JOBDEFINITIONARN_DESCRIPTOR)
        field(JOBDEFINITIONNAME_DESCRIPTOR)
        field(JOBRESOURCES_DESCRIPTOR)
        field(MODELEXPLAINABILITYAPPSPECIFICATION_DESCRIPTOR)
        field(MODELEXPLAINABILITYBASELINECONFIG_DESCRIPTOR)
        field(MODELEXPLAINABILITYJOBINPUT_DESCRIPTOR)
        field(MODELEXPLAINABILITYJOBOUTPUTCONFIG_DESCRIPTOR)
        field(NETWORKCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                JOBDEFINITIONARN_DESCRIPTOR.index -> builder.jobDefinitionArn = deserializeString()
                JOBDEFINITIONNAME_DESCRIPTOR.index -> builder.jobDefinitionName = deserializeString()
                JOBRESOURCES_DESCRIPTOR.index -> builder.jobResources = deserializeMonitoringResourcesDocument(deserializer)
                MODELEXPLAINABILITYAPPSPECIFICATION_DESCRIPTOR.index -> builder.modelExplainabilityAppSpecification = deserializeModelExplainabilityAppSpecificationDocument(deserializer)
                MODELEXPLAINABILITYBASELINECONFIG_DESCRIPTOR.index -> builder.modelExplainabilityBaselineConfig = deserializeModelExplainabilityBaselineConfigDocument(deserializer)
                MODELEXPLAINABILITYJOBINPUT_DESCRIPTOR.index -> builder.modelExplainabilityJobInput = deserializeModelExplainabilityJobInputDocument(deserializer)
                MODELEXPLAINABILITYJOBOUTPUTCONFIG_DESCRIPTOR.index -> builder.modelExplainabilityJobOutputConfig = deserializeMonitoringOutputConfigDocument(deserializer)
                NETWORKCONFIG_DESCRIPTOR.index -> builder.networkConfig = deserializeMonitoringNetworkConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeMonitoringStoppingConditionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
