// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.DescribeModelCardResponse
import aws.sdk.kotlin.services.sagemaker.model.ModelCardProcessingStatus
import aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig
import aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeModelCardOperationDeserializer: HttpDeserialize<DescribeModelCardResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeModelCardResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeModelCardError(context, call)
        }
        val builder = DescribeModelCardResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeModelCardOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeModelCardError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeModelCardOperationBody(builder: DescribeModelCardResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Content"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELCARDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelCardArn"))
    val MODELCARDNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelCardName"))
    val MODELCARDPROCESSINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ModelCardProcessingStatus"))
    val MODELCARDSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ModelCardStatus"))
    val MODELCARDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ModelCardVersion"))
    val SECURITYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SecurityConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELCARDARN_DESCRIPTOR)
        field(MODELCARDNAME_DESCRIPTOR)
        field(MODELCARDPROCESSINGSTATUS_DESCRIPTOR)
        field(MODELCARDSTATUS_DESCRIPTOR)
        field(MODELCARDVERSION_DESCRIPTOR)
        field(SECURITYCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTENT_DESCRIPTOR.index -> builder.content = deserializeString()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELCARDARN_DESCRIPTOR.index -> builder.modelCardArn = deserializeString()
                MODELCARDNAME_DESCRIPTOR.index -> builder.modelCardName = deserializeString()
                MODELCARDPROCESSINGSTATUS_DESCRIPTOR.index -> builder.modelCardProcessingStatus = deserializeString().let { ModelCardProcessingStatus.fromValue(it) }
                MODELCARDSTATUS_DESCRIPTOR.index -> builder.modelCardStatus = deserializeString().let { ModelCardStatus.fromValue(it) }
                MODELCARDVERSION_DESCRIPTOR.index -> builder.modelCardVersion = deserializeInt()
                SECURITYCONFIG_DESCRIPTOR.index -> builder.securityConfig = deserializeModelCardSecurityConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
