// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.DescribeHubResponse
import aws.sdk.kotlin.services.sagemaker.model.HubS3StorageConfig
import aws.sdk.kotlin.services.sagemaker.model.HubStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeHubOperationDeserializer: HttpDeserialize<DescribeHubResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeHubResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeHubError(context, call)
        }
        val builder = DescribeHubResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeHubOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeHubError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHubOperationBody(builder: DescribeHubResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HUBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubArn"))
    val HUBDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubDescription"))
    val HUBDISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubDisplayName"))
    val HUBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubName"))
    val HUBSEARCHKEYWORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HubSearchKeywords"))
    val HUBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HubStatus"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val S3STORAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("S3StorageConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HUBARN_DESCRIPTOR)
        field(HUBDESCRIPTION_DESCRIPTOR)
        field(HUBDISPLAYNAME_DESCRIPTOR)
        field(HUBNAME_DESCRIPTOR)
        field(HUBSEARCHKEYWORDS_DESCRIPTOR)
        field(HUBSTATUS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(S3STORAGECONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HUBARN_DESCRIPTOR.index -> builder.hubArn = deserializeString()
                HUBDESCRIPTION_DESCRIPTOR.index -> builder.hubDescription = deserializeString()
                HUBDISPLAYNAME_DESCRIPTOR.index -> builder.hubDisplayName = deserializeString()
                HUBNAME_DESCRIPTOR.index -> builder.hubName = deserializeString()
                HUBSEARCHKEYWORDS_DESCRIPTOR.index -> builder.hubSearchKeywords =
                    deserializer.deserializeList(HUBSEARCHKEYWORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HUBSTATUS_DESCRIPTOR.index -> builder.hubStatus = deserializeString().let { HubStatus.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                S3STORAGECONFIG_DESCRIPTOR.index -> builder.s3StorageConfig = deserializeHubS3StorageConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
