// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.DescribeFlowDefinitionResponse
import aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionStatus
import aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConfig
import aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig
import aws.sdk.kotlin.services.sagemaker.model.HumanLoopRequestSource
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeFlowDefinitionOperationDeserializer: HttpDeserialize<DescribeFlowDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeFlowDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFlowDefinitionError(context, call)
        }
        val builder = DescribeFlowDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFlowDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeFlowDefinitionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFlowDefinitionOperationBody(builder: DescribeFlowDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val FLOWDEFINITIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FlowDefinitionArn"))
    val FLOWDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FlowDefinitionName"))
    val FLOWDEFINITIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FlowDefinitionStatus"))
    val HUMANLOOPACTIVATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HumanLoopActivationConfig"))
    val HUMANLOOPCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HumanLoopConfig"))
    val HUMANLOOPREQUESTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HumanLoopRequestSource"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(FLOWDEFINITIONARN_DESCRIPTOR)
        field(FLOWDEFINITIONNAME_DESCRIPTOR)
        field(FLOWDEFINITIONSTATUS_DESCRIPTOR)
        field(HUMANLOOPACTIVATIONCONFIG_DESCRIPTOR)
        field(HUMANLOOPCONFIG_DESCRIPTOR)
        field(HUMANLOOPREQUESTSOURCE_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                FLOWDEFINITIONARN_DESCRIPTOR.index -> builder.flowDefinitionArn = deserializeString()
                FLOWDEFINITIONNAME_DESCRIPTOR.index -> builder.flowDefinitionName = deserializeString()
                FLOWDEFINITIONSTATUS_DESCRIPTOR.index -> builder.flowDefinitionStatus = deserializeString().let { FlowDefinitionStatus.fromValue(it) }
                HUMANLOOPACTIVATIONCONFIG_DESCRIPTOR.index -> builder.humanLoopActivationConfig = deserializeHumanLoopActivationConfigDocument(deserializer)
                HUMANLOOPCONFIG_DESCRIPTOR.index -> builder.humanLoopConfig = deserializeHumanLoopConfigDocument(deserializer)
                HUMANLOOPREQUESTSOURCE_DESCRIPTOR.index -> builder.humanLoopRequestSource = deserializeHumanLoopRequestSourceDocument(deserializer)
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeFlowDefinitionOutputConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
