// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse
import aws.sdk.kotlin.services.sagemaker.model.FeatureDefinition
import aws.sdk.kotlin.services.sagemaker.model.FeatureGroupStatus
import aws.sdk.kotlin.services.sagemaker.model.LastUpdateStatus
import aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig
import aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus
import aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeFeatureGroupOperationDeserializer: HttpDeserialize<DescribeFeatureGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeFeatureGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFeatureGroupError(context, call)
        }
        val builder = DescribeFeatureGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFeatureGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeFeatureGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFeatureGroupOperationBody(builder: DescribeFeatureGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val EVENTTIMEFEATURENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventTimeFeatureName"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val FEATUREDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeatureDefinitions"))
    val FEATUREGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FeatureGroupArn"))
    val FEATUREGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FeatureGroupName"))
    val FEATUREGROUPSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FeatureGroupStatus"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val LASTUPDATESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastUpdateStatus"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OFFLINESTORECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OfflineStoreConfig"))
    val OFFLINESTORESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OfflineStoreStatus"))
    val ONLINESTORECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OnlineStoreConfig"))
    val ONLINESTORETOTALSIZEBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("OnlineStoreTotalSizeBytes"))
    val RECORDIDENTIFIERFEATURENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecordIdentifierFeatureName"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EVENTTIMEFEATURENAME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(FEATUREDEFINITIONS_DESCRIPTOR)
        field(FEATUREGROUPARN_DESCRIPTOR)
        field(FEATUREGROUPNAME_DESCRIPTOR)
        field(FEATUREGROUPSTATUS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(LASTUPDATESTATUS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(OFFLINESTORECONFIG_DESCRIPTOR)
        field(OFFLINESTORESTATUS_DESCRIPTOR)
        field(ONLINESTORECONFIG_DESCRIPTOR)
        field(ONLINESTORETOTALSIZEBYTES_DESCRIPTOR)
        field(RECORDIDENTIFIERFEATURENAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EVENTTIMEFEATURENAME_DESCRIPTOR.index -> builder.eventTimeFeatureName = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                FEATUREDEFINITIONS_DESCRIPTOR.index -> builder.featureDefinitions =
                    deserializer.deserializeList(FEATUREDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<FeatureDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFeatureDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FEATUREGROUPARN_DESCRIPTOR.index -> builder.featureGroupArn = deserializeString()
                FEATUREGROUPNAME_DESCRIPTOR.index -> builder.featureGroupName = deserializeString()
                FEATUREGROUPSTATUS_DESCRIPTOR.index -> builder.featureGroupStatus = deserializeString().let { FeatureGroupStatus.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTUPDATESTATUS_DESCRIPTOR.index -> builder.lastUpdateStatus = deserializeLastUpdateStatusDocument(deserializer)
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                OFFLINESTORECONFIG_DESCRIPTOR.index -> builder.offlineStoreConfig = deserializeOfflineStoreConfigDocument(deserializer)
                OFFLINESTORESTATUS_DESCRIPTOR.index -> builder.offlineStoreStatus = deserializeOfflineStoreStatusDocument(deserializer)
                ONLINESTORECONFIG_DESCRIPTOR.index -> builder.onlineStoreConfig = deserializeOnlineStoreConfigDocument(deserializer)
                ONLINESTORETOTALSIZEBYTES_DESCRIPTOR.index -> builder.onlineStoreTotalSizeBytes = deserializeLong()
                RECORDIDENTIFIERFEATURENAME_DESCRIPTOR.index -> builder.recordIdentifierFeatureName = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
