// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.ActionSource
import aws.sdk.kotlin.services.sagemaker.model.ActionStatus
import aws.sdk.kotlin.services.sagemaker.model.DescribeActionResponse
import aws.sdk.kotlin.services.sagemaker.model.MetadataProperties
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class DescribeActionOperationDeserializer: HttpDeserialize<DescribeActionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeActionError(context, call)
        }
        val builder = DescribeActionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeActionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeActionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeActionOperationBody(builder: DescribeActionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActionArn"))
    val ACTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActionName"))
    val ACTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActionType"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val LINEAGEGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LineageGroupArn"))
    val METADATAPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MetadataProperties"))
    val PROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Properties"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Source"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONARN_DESCRIPTOR)
        field(ACTIONNAME_DESCRIPTOR)
        field(ACTIONTYPE_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(LINEAGEGROUPARN_DESCRIPTOR)
        field(METADATAPROPERTIES_DESCRIPTOR)
        field(PROPERTIES_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONARN_DESCRIPTOR.index -> builder.actionArn = deserializeString()
                ACTIONNAME_DESCRIPTOR.index -> builder.actionName = deserializeString()
                ACTIONTYPE_DESCRIPTOR.index -> builder.actionType = deserializeString()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LINEAGEGROUPARN_DESCRIPTOR.index -> builder.lineageGroupArn = deserializeString()
                METADATAPROPERTIES_DESCRIPTOR.index -> builder.metadataProperties = deserializeMetadataPropertiesDocument(deserializer)
                PROPERTIES_DESCRIPTOR.index -> builder.properties =
                    deserializer.deserializeMap(PROPERTIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeActionSourceDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ActionStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
