// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig
import aws.sdk.kotlin.services.sagemaker.model.BatchStrategy
import aws.sdk.kotlin.services.sagemaker.model.CreateTransformJobRequest
import aws.sdk.kotlin.services.sagemaker.model.DataProcessing
import aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig
import aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.sdk.kotlin.services.sagemaker.model.TransformInput
import aws.sdk.kotlin.services.sagemaker.model.TransformOutput
import aws.sdk.kotlin.services.sagemaker.model.TransformResources
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateTransformJobOperationSerializer: HttpSerialize<CreateTransformJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateTransformJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateTransformJobOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateTransformJobOperationBody(context: ExecutionContext, input: CreateTransformJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val BATCHSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("BatchStrategy"))
    val DATACAPTURECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataCaptureConfig"))
    val DATAPROCESSING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataProcessing"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Environment"))
    val EXPERIMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExperimentConfig"))
    val MAXCONCURRENTTRANSFORMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxConcurrentTransforms"))
    val MAXPAYLOADINMB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxPayloadInMB"))
    val MODELCLIENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelClientConfig"))
    val MODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TRANSFORMINPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TransformInput"))
    val TRANSFORMJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TransformJobName"))
    val TRANSFORMOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TransformOutput"))
    val TRANSFORMRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TransformResources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BATCHSTRATEGY_DESCRIPTOR)
        field(DATACAPTURECONFIG_DESCRIPTOR)
        field(DATAPROCESSING_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(EXPERIMENTCONFIG_DESCRIPTOR)
        field(MAXCONCURRENTTRANSFORMS_DESCRIPTOR)
        field(MAXPAYLOADINMB_DESCRIPTOR)
        field(MODELCLIENTCONFIG_DESCRIPTOR)
        field(MODELNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRANSFORMINPUT_DESCRIPTOR)
        field(TRANSFORMJOBNAME_DESCRIPTOR)
        field(TRANSFORMOUTPUT_DESCRIPTOR)
        field(TRANSFORMRESOURCES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.batchStrategy?.let { field(BATCHSTRATEGY_DESCRIPTOR, it.value) }
        input.dataCaptureConfig?.let { field(DATACAPTURECONFIG_DESCRIPTOR, it, ::serializeBatchDataCaptureConfigDocument) }
        input.dataProcessing?.let { field(DATAPROCESSING_DESCRIPTOR, it, ::serializeDataProcessingDocument) }
        if (input.environment != null) {
            mapField(ENVIRONMENT_DESCRIPTOR) {
                input.environment.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.experimentConfig?.let { field(EXPERIMENTCONFIG_DESCRIPTOR, it, ::serializeExperimentConfigDocument) }
        input.maxConcurrentTransforms?.let { field(MAXCONCURRENTTRANSFORMS_DESCRIPTOR, it) }
        input.maxPayloadInMb?.let { field(MAXPAYLOADINMB_DESCRIPTOR, it) }
        input.modelClientConfig?.let { field(MODELCLIENTCONFIG_DESCRIPTOR, it, ::serializeModelClientConfigDocument) }
        input.modelName?.let { field(MODELNAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.transformInput?.let { field(TRANSFORMINPUT_DESCRIPTOR, it, ::serializeTransformInputDocument) }
        input.transformJobName?.let { field(TRANSFORMJOBNAME_DESCRIPTOR, it) }
        input.transformOutput?.let { field(TRANSFORMOUTPUT_DESCRIPTOR, it, ::serializeTransformOutputDocument) }
        input.transformResources?.let { field(TRANSFORMRESOURCES_DESCRIPTOR, it, ::serializeTransformResourcesDocument) }
    }
    return serializer.toByteArray()
}
