// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the `CreateUserProfile` API is called, and as `DefaultUserSettings` when the `CreateDomain` API is called.
 *
 * `SecurityGroups` is aggregated when specified in both calls. For all other settings in `UserSettings`, the values specified in `CreateUserProfile` take precedence over those specified in `CreateDomain`.
 */
public class UserSettings private constructor(builder: Builder) {
    /**
     * The Canvas app settings.
     */
    public val canvasAppSettings: aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings? = builder.canvasAppSettings
    /**
     * The execution role for the user.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The Jupyter server's app settings.
     */
    public val jupyterServerAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings? = builder.jupyterServerAppSettings
    /**
     * The kernel gateway app settings.
     */
    public val kernelGatewayAppSettings: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings? = builder.kernelGatewayAppSettings
    /**
     * A collection of settings that configure the `RSessionGateway` app.
     */
    public val rSessionAppSettings: aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings? = builder.rSessionAppSettings
    /**
     * A collection of settings that configure user interaction with the `RStudioServerPro` app.
     */
    public val rStudioServerProAppSettings: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings? = builder.rStudioServerProAppSettings
    /**
     * The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     *
     * Optional when the `CreateDomain.AppNetworkAccessType` parameter is set to `PublicInternetOnly`.
     *
     * Required when the `CreateDomain.AppNetworkAccessType` parameter is set to `VpcOnly`, unless specified as part of the `DefaultUserSettings` for the domain.
     *
     * Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * Specifies options for sharing SageMaker Studio notebooks.
     */
    public val sharingSettings: aws.sdk.kotlin.services.sagemaker.model.SharingSettings? = builder.sharingSettings
    /**
     * The TensorBoard app settings.
     */
    public val tensorBoardAppSettings: aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings? = builder.tensorBoardAppSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UserSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserSettings(")
        append("canvasAppSettings=$canvasAppSettings,")
        append("executionRole=$executionRole,")
        append("jupyterServerAppSettings=$jupyterServerAppSettings,")
        append("kernelGatewayAppSettings=$kernelGatewayAppSettings,")
        append("rSessionAppSettings=$rSessionAppSettings,")
        append("rStudioServerProAppSettings=$rStudioServerProAppSettings,")
        append("securityGroups=$securityGroups,")
        append("sharingSettings=$sharingSettings,")
        append("tensorBoardAppSettings=$tensorBoardAppSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = canvasAppSettings?.hashCode() ?: 0
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (jupyterServerAppSettings?.hashCode() ?: 0)
        result = 31 * result + (kernelGatewayAppSettings?.hashCode() ?: 0)
        result = 31 * result + (rSessionAppSettings?.hashCode() ?: 0)
        result = 31 * result + (rStudioServerProAppSettings?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sharingSettings?.hashCode() ?: 0)
        result = 31 * result + (tensorBoardAppSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserSettings

        if (canvasAppSettings != other.canvasAppSettings) return false
        if (executionRole != other.executionRole) return false
        if (jupyterServerAppSettings != other.jupyterServerAppSettings) return false
        if (kernelGatewayAppSettings != other.kernelGatewayAppSettings) return false
        if (rSessionAppSettings != other.rSessionAppSettings) return false
        if (rStudioServerProAppSettings != other.rStudioServerProAppSettings) return false
        if (securityGroups != other.securityGroups) return false
        if (sharingSettings != other.sharingSettings) return false
        if (tensorBoardAppSettings != other.tensorBoardAppSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UserSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Canvas app settings.
         */
        public var canvasAppSettings: aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings? = null
        /**
         * The execution role for the user.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The Jupyter server's app settings.
         */
        public var jupyterServerAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings? = null
        /**
         * The kernel gateway app settings.
         */
        public var kernelGatewayAppSettings: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings? = null
        /**
         * A collection of settings that configure the `RSessionGateway` app.
         */
        public var rSessionAppSettings: aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings? = null
        /**
         * A collection of settings that configure user interaction with the `RStudioServerPro` app.
         */
        public var rStudioServerProAppSettings: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings? = null
        /**
         * The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
         *
         * Optional when the `CreateDomain.AppNetworkAccessType` parameter is set to `PublicInternetOnly`.
         *
         * Required when the `CreateDomain.AppNetworkAccessType` parameter is set to `VpcOnly`, unless specified as part of the `DefaultUserSettings` for the domain.
         *
         * Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
         */
        public var securityGroups: List<String>? = null
        /**
         * Specifies options for sharing SageMaker Studio notebooks.
         */
        public var sharingSettings: aws.sdk.kotlin.services.sagemaker.model.SharingSettings? = null
        /**
         * The TensorBoard app settings.
         */
        public var tensorBoardAppSettings: aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UserSettings) : this() {
            this.canvasAppSettings = x.canvasAppSettings
            this.executionRole = x.executionRole
            this.jupyterServerAppSettings = x.jupyterServerAppSettings
            this.kernelGatewayAppSettings = x.kernelGatewayAppSettings
            this.rSessionAppSettings = x.rSessionAppSettings
            this.rStudioServerProAppSettings = x.rStudioServerProAppSettings
            this.securityGroups = x.securityGroups
            this.sharingSettings = x.sharingSettings
            this.tensorBoardAppSettings = x.tensorBoardAppSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UserSettings = UserSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings] inside the given [block]
         */
        public fun canvasAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings.Builder.() -> kotlin.Unit) {
            this.canvasAppSettings = aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings] inside the given [block]
         */
        public fun jupyterServerAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings.Builder.() -> kotlin.Unit) {
            this.jupyterServerAppSettings = aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings] inside the given [block]
         */
        public fun kernelGatewayAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings.Builder.() -> kotlin.Unit) {
            this.kernelGatewayAppSettings = aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings] inside the given [block]
         */
        public fun rSessionAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings.Builder.() -> kotlin.Unit) {
            this.rSessionAppSettings = aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings] inside the given [block]
         */
        public fun rStudioServerProAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings.Builder.() -> kotlin.Unit) {
            this.rStudioServerProAppSettings = aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SharingSettings] inside the given [block]
         */
        public fun sharingSettings(block: aws.sdk.kotlin.services.sagemaker.model.SharingSettings.Builder.() -> kotlin.Unit) {
            this.sharingSettings = aws.sdk.kotlin.services.sagemaker.model.SharingSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings] inside the given [block]
         */
        public fun tensorBoardAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings.Builder.() -> kotlin.Unit) {
            this.tensorBoardAppSettings = aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings.invoke(block)
        }
    }
}
