// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Describes the input source of a transform job and the way the transform job consumes it.
 */
public class TransformInput private constructor(builder: Builder) {
    /**
     * If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is `None`.
     */
    public val compressionType: aws.sdk.kotlin.services.sagemaker.model.CompressionType? = builder.compressionType
    /**
     * The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * Describes the location of the channel data, which is, the S3 location of the input data that the model can consume.
     */
    public val dataSource: aws.sdk.kotlin.services.sagemaker.model.TransformDataSource? = builder.dataSource
    /**
     * The method to use to split the transform job's data files into smaller batches. Splitting is necessary when the total size of each object is too large to fit in a single request. You can also use data splitting to improve performance by processing multiple concurrent mini-batches. The default value for `SplitType` is `None`, which indicates that input data files are not split, and request payloads contain the entire contents of an input object. Set the value of this parameter to `Line` to split records on a newline character boundary. `SplitType` also supports a number of record-oriented binary data formats. Currently, the supported record formats are:
     * + RecordIO
     * + TFRecord
     *
     * When splitting is enabled, the size of a mini-batch depends on the values of the `BatchStrategy` and `MaxPayloadInMB` parameters. When the value of `BatchStrategy` is `MultiRecord`, Amazon SageMaker sends the maximum number of records in each request, up to the `MaxPayloadInMB` limit. If the value of `BatchStrategy` is `SingleRecord`, Amazon SageMaker sends individual records in each request.
     *
     * Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is applied to a binary data format, padding is removed if the value of `BatchStrategy` is set to `SingleRecord`. Padding is not removed if the value of `BatchStrategy` is set to `MultiRecord`.
     *
     * For more information about `RecordIO`, see [Create a Dataset Using RecordIO](https://mxnet.apache.org/api/faq/recordio) in the MXNet documentation. For more information about `TFRecord`, see [Consuming TFRecord data](https://www.tensorflow.org/guide/data#consuming_tfrecord_data) in the TensorFlow documentation.
     */
    public val splitType: aws.sdk.kotlin.services.sagemaker.model.SplitType? = builder.splitType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TransformInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransformInput(")
        append("compressionType=$compressionType,")
        append("contentType=$contentType,")
        append("dataSource=$dataSource,")
        append("splitType=$splitType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compressionType?.hashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (splitType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransformInput

        if (compressionType != other.compressionType) return false
        if (contentType != other.contentType) return false
        if (dataSource != other.dataSource) return false
        if (splitType != other.splitType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TransformInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is `None`.
         */
        public var compressionType: aws.sdk.kotlin.services.sagemaker.model.CompressionType? = null
        /**
         * The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.
         */
        public var contentType: kotlin.String? = null
        /**
         * Describes the location of the channel data, which is, the S3 location of the input data that the model can consume.
         */
        public var dataSource: aws.sdk.kotlin.services.sagemaker.model.TransformDataSource? = null
        /**
         * The method to use to split the transform job's data files into smaller batches. Splitting is necessary when the total size of each object is too large to fit in a single request. You can also use data splitting to improve performance by processing multiple concurrent mini-batches. The default value for `SplitType` is `None`, which indicates that input data files are not split, and request payloads contain the entire contents of an input object. Set the value of this parameter to `Line` to split records on a newline character boundary. `SplitType` also supports a number of record-oriented binary data formats. Currently, the supported record formats are:
         * + RecordIO
         * + TFRecord
         *
         * When splitting is enabled, the size of a mini-batch depends on the values of the `BatchStrategy` and `MaxPayloadInMB` parameters. When the value of `BatchStrategy` is `MultiRecord`, Amazon SageMaker sends the maximum number of records in each request, up to the `MaxPayloadInMB` limit. If the value of `BatchStrategy` is `SingleRecord`, Amazon SageMaker sends individual records in each request.
         *
         * Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is applied to a binary data format, padding is removed if the value of `BatchStrategy` is set to `SingleRecord`. Padding is not removed if the value of `BatchStrategy` is set to `MultiRecord`.
         *
         * For more information about `RecordIO`, see [Create a Dataset Using RecordIO](https://mxnet.apache.org/api/faq/recordio) in the MXNet documentation. For more information about `TFRecord`, see [Consuming TFRecord data](https://www.tensorflow.org/guide/data#consuming_tfrecord_data) in the TensorFlow documentation.
         */
        public var splitType: aws.sdk.kotlin.services.sagemaker.model.SplitType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TransformInput) : this() {
            this.compressionType = x.compressionType
            this.contentType = x.contentType
            this.dataSource = x.dataSource
            this.splitType = x.splitType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TransformInput = TransformInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformDataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.sagemaker.model.TransformDataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.sagemaker.model.TransformDataSource.invoke(block)
        }
    }
}
