// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines how the algorithm is used for a training job.
 */
public class TrainingSpecification private constructor(builder: Builder) {
    /**
     * A list of `MetricDefinition` objects, which are used for parsing metrics generated by the algorithm.
     */
    public val metricDefinitions: List<MetricDefinition>? = builder.metricDefinitions
    /**
     * A list of the `HyperParameterSpecification` objects, that define the supported hyperparameters. This is required if the algorithm supports automatic model tuning.>
     */
    public val supportedHyperParameters: List<HyperParameterSpecification>? = builder.supportedHyperParameters
    /**
     * A list of the instance types that this algorithm can use for training.
     */
    public val supportedTrainingInstanceTypes: List<TrainingInstanceType>? = builder.supportedTrainingInstanceTypes
    /**
     * A list of the metrics that the algorithm emits that can be used as the objective metric in a hyperparameter tuning job.
     */
    public val supportedTuningJobObjectiveMetrics: List<HyperParameterTuningJobObjective>? = builder.supportedTuningJobObjectiveMetrics
    /**
     * Indicates whether the algorithm supports distributed training. If set to false, buyers can't request more than one instance during training.
     */
    public val supportsDistributedTraining: kotlin.Boolean = builder.supportsDistributedTraining
    /**
     * A list of `ChannelSpecification` objects, which specify the input sources to be used by the algorithm.
     */
    public val trainingChannels: List<ChannelSpecification>? = builder.trainingChannels
    /**
     * The Amazon ECR registry path of the Docker image that contains the training algorithm.
     */
    public val trainingImage: kotlin.String? = builder.trainingImage
    /**
     * An MD5 hash of the training algorithm that identifies the Docker image used for training.
     */
    public val trainingImageDigest: kotlin.String? = builder.trainingImageDigest

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrainingSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrainingSpecification(")
        append("metricDefinitions=$metricDefinitions,")
        append("supportedHyperParameters=$supportedHyperParameters,")
        append("supportedTrainingInstanceTypes=$supportedTrainingInstanceTypes,")
        append("supportedTuningJobObjectiveMetrics=$supportedTuningJobObjectiveMetrics,")
        append("supportsDistributedTraining=$supportsDistributedTraining,")
        append("trainingChannels=$trainingChannels,")
        append("trainingImage=$trainingImage,")
        append("trainingImageDigest=$trainingImageDigest")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricDefinitions?.hashCode() ?: 0
        result = 31 * result + (supportedHyperParameters?.hashCode() ?: 0)
        result = 31 * result + (supportedTrainingInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedTuningJobObjectiveMetrics?.hashCode() ?: 0)
        result = 31 * result + (supportsDistributedTraining.hashCode())
        result = 31 * result + (trainingChannels?.hashCode() ?: 0)
        result = 31 * result + (trainingImage?.hashCode() ?: 0)
        result = 31 * result + (trainingImageDigest?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrainingSpecification

        if (metricDefinitions != other.metricDefinitions) return false
        if (supportedHyperParameters != other.supportedHyperParameters) return false
        if (supportedTrainingInstanceTypes != other.supportedTrainingInstanceTypes) return false
        if (supportedTuningJobObjectiveMetrics != other.supportedTuningJobObjectiveMetrics) return false
        if (supportsDistributedTraining != other.supportsDistributedTraining) return false
        if (trainingChannels != other.trainingChannels) return false
        if (trainingImage != other.trainingImage) return false
        if (trainingImageDigest != other.trainingImageDigest) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrainingSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of `MetricDefinition` objects, which are used for parsing metrics generated by the algorithm.
         */
        public var metricDefinitions: List<MetricDefinition>? = null
        /**
         * A list of the `HyperParameterSpecification` objects, that define the supported hyperparameters. This is required if the algorithm supports automatic model tuning.>
         */
        public var supportedHyperParameters: List<HyperParameterSpecification>? = null
        /**
         * A list of the instance types that this algorithm can use for training.
         */
        public var supportedTrainingInstanceTypes: List<TrainingInstanceType>? = null
        /**
         * A list of the metrics that the algorithm emits that can be used as the objective metric in a hyperparameter tuning job.
         */
        public var supportedTuningJobObjectiveMetrics: List<HyperParameterTuningJobObjective>? = null
        /**
         * Indicates whether the algorithm supports distributed training. If set to false, buyers can't request more than one instance during training.
         */
        public var supportsDistributedTraining: kotlin.Boolean = false
        /**
         * A list of `ChannelSpecification` objects, which specify the input sources to be used by the algorithm.
         */
        public var trainingChannels: List<ChannelSpecification>? = null
        /**
         * The Amazon ECR registry path of the Docker image that contains the training algorithm.
         */
        public var trainingImage: kotlin.String? = null
        /**
         * An MD5 hash of the training algorithm that identifies the Docker image used for training.
         */
        public var trainingImageDigest: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrainingSpecification) : this() {
            this.metricDefinitions = x.metricDefinitions
            this.supportedHyperParameters = x.supportedHyperParameters
            this.supportedTrainingInstanceTypes = x.supportedTrainingInstanceTypes
            this.supportedTuningJobObjectiveMetrics = x.supportedTuningJobObjectiveMetrics
            this.supportsDistributedTraining = x.supportsDistributedTraining
            this.trainingChannels = x.trainingChannels
            this.trainingImage = x.trainingImage
            this.trainingImageDigest = x.trainingImageDigest
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrainingSpecification = TrainingSpecification(this)
    }
}
