// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Transformations allowed on the dataset. Supported transformations are `Filling` and `Aggregation`. `Filling` specifies how to add values to missing values in the dataset. `Aggregation` defines how to aggregate data that does not align with forecast frequency.
 */
public class TimeSeriesTransformations private constructor(builder: Builder) {
    /**
     * A key value pair defining the aggregation method for a column, where the key is the column name and the value is the aggregation method.
     *
     * The supported aggregation methods are `sum` (default), `avg`, `first`, `min`, `max`.
     *
     * Aggregation is only supported for the target column.
     */
    public val aggregation: Map<String, AggregationTransformationValue>? = builder.aggregation
    /**
     * A key value pair defining the filling method for a column, where the key is the column name and the value is an object which defines the filling logic. You can specify multiple filling methods for a single column.
     *
     * The supported filling methods and their corresponding options are:
     * + `frontfill`: `none` (Supported only for target column)
     * + `middlefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     * + `backfill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     * + `futurefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     *
     * To set a filling method to a specific value, set the fill parameter to the chosen filling method value (for example `"backfill" : "value"`), and define the filling value in an additional parameter prefixed with "_value". For example, to set `backfill` to a value of `2`, you must include two parameters: `"backfill": "value"` and `"backfill_value":"2"`.
     */
    public val filling: Map<String, Map<String, String>>? = builder.filling

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeSeriesTransformations(")
        append("aggregation=$aggregation,")
        append("filling=$filling")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregation?.hashCode() ?: 0
        result = 31 * result + (filling?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeSeriesTransformations

        if (aggregation != other.aggregation) return false
        if (filling != other.filling) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A key value pair defining the aggregation method for a column, where the key is the column name and the value is the aggregation method.
         *
         * The supported aggregation methods are `sum` (default), `avg`, `first`, `min`, `max`.
         *
         * Aggregation is only supported for the target column.
         */
        public var aggregation: Map<String, AggregationTransformationValue>? = null
        /**
         * A key value pair defining the filling method for a column, where the key is the column name and the value is an object which defines the filling logic. You can specify multiple filling methods for a single column.
         *
         * The supported filling methods and their corresponding options are:
         * + `frontfill`: `none` (Supported only for target column)
         * + `middlefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         * + `backfill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         * + `futurefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         *
         * To set a filling method to a specific value, set the fill parameter to the chosen filling method value (for example `"backfill" : "value"`), and define the filling value in an additional parameter prefixed with "_value". For example, to set `backfill` to a value of `2`, you must include two parameters: `"backfill": "value"` and `"backfill_value":"2"`.
         */
        public var filling: Map<String, Map<String, String>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations) : this() {
            this.aggregation = x.aggregation
            this.filling = x.filling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesTransformations = TimeSeriesTransformations(this)
    }
}
