// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The collection of settings used by an AutoML job V2 for the `TABULAR` problem type.
 */
public class TabularJobConfig private constructor(builder: Builder) {
    /**
     * The configuration information of how model candidates are generated.
     */
    public val candidateGenerationConfig: aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig? = builder.candidateGenerationConfig
    /**
     * How long a job is allowed to run, or how many candidates a job is allowed to generate.
     */
    public val completionCriteria: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria? = builder.completionCriteria
    /**
     * A URL to the Amazon S3 data source containing selected features from the input data source to run an Autopilot job V2. You can input `FeatureAttributeNames` (optional) in JSON format as shown below:
     *
     * `{ "FeatureAttributeNames":["col1", "col2", ...] }`.
     *
     * You can also specify the data type of the feature (optional) in the format shown below:
     *
     * `{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }`
     *
     * These column keys may not include the target column.
     *
     * In ensembling mode, Autopilot only supports the following data types: `numeric`, `categorical`, `text`, and `datetime`. In HPO mode, Autopilot can support `numeric`, `categorical`, `text`, `datetime`, and `sequence`.
     *
     * If only `FeatureDataTypes` is provided, the column keys (`col1`, `col2`,..) should be a subset of the column names in the input data.
     *
     * If both `FeatureDataTypes` and `FeatureAttributeNames` are provided, then the column keys should be a subset of the column names provided in `FeatureAttributeNames`.
     *
     * The key name `FeatureAttributeNames` is fixed. The values listed in `["col1", "col2", ...]` are case sensitive and should be a list of strings containing unique values that are a subset of the column names in the input data. The list of columns provided must not include the target column.
     */
    public val featureSpecificationS3Uri: kotlin.String? = builder.featureSpecificationS3Uri
    /**
     * Generates possible candidates without training the models. A model candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.
     */
    public val generateCandidateDefinitionsOnly: kotlin.Boolean = builder.generateCandidateDefinitionsOnly
    /**
     * The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot choose for you based on the dataset size by selecting `AUTO`. In `AUTO` mode, Autopilot chooses `ENSEMBLING` for datasets smaller than 100 MB, and `HYPERPARAMETER_TUNING` for larger ones.
     *
     * The `ENSEMBLING` mode uses a multi-stack ensemble model to predict classification and regression tasks directly from your dataset. This machine learning mode combines several base models to produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions from contributing members. A multi-stack ensemble model can provide better performance over a single model by combining the predictive capabilities of multiple models. See [Autopilot algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) for a list of algorithms supported by `ENSEMBLING` mode.
     *
     * The `HYPERPARAMETER_TUNING` (HPO) mode uses the best hyperparameters to train the best version of a model. HPO automatically selects an algorithm for the type of problem you want to solve. Then HPO finds the best hyperparameters according to your objective metric. See [Autopilot algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) for a list of algorithms supported by `HYPERPARAMETER_TUNING` mode.
     */
    public val mode: aws.sdk.kotlin.services.sagemaker.model.AutoMlMode? = builder.mode
    /**
     * The type of supervised learning problem available for the model candidates of the AutoML job V2. For more information, see [ Amazon SageMaker Autopilot problem types](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types).
     *
     * You must either specify the type of supervised learning problem in `ProblemType` and provide the [AutoMLJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html#sagemaker-CreateAutoMLJobV2-request-AutoMLJobObjective) metric, or none at all.
     */
    public val problemType: aws.sdk.kotlin.services.sagemaker.model.ProblemType? = builder.problemType
    /**
     * If specified, this column name indicates which column of the dataset should be treated as sample weights for use by the objective metric during the training, evaluation, and the selection of the best model. This column is not considered as a predictive feature. For more information on Autopilot metrics, see [Metrics and validation](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html).
     *
     * Sample weights should be numeric, non-negative, with larger values indicating which rows are more important than others. Data points that have invalid or no weight value are excluded.
     *
     * Support for sample weights is available in [Ensembling](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html) mode only.
     */
    public val sampleWeightAttributeName: kotlin.String? = builder.sampleWeightAttributeName
    /**
     * The name of the target variable in supervised learning, usually represented by 'y'.
     */
    public val targetAttributeName: kotlin.String? = builder.targetAttributeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TabularJobConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TabularJobConfig(")
        append("candidateGenerationConfig=$candidateGenerationConfig,")
        append("completionCriteria=$completionCriteria,")
        append("featureSpecificationS3Uri=$featureSpecificationS3Uri,")
        append("generateCandidateDefinitionsOnly=$generateCandidateDefinitionsOnly,")
        append("mode=$mode,")
        append("problemType=$problemType,")
        append("sampleWeightAttributeName=$sampleWeightAttributeName,")
        append("targetAttributeName=$targetAttributeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = candidateGenerationConfig?.hashCode() ?: 0
        result = 31 * result + (completionCriteria?.hashCode() ?: 0)
        result = 31 * result + (featureSpecificationS3Uri?.hashCode() ?: 0)
        result = 31 * result + (generateCandidateDefinitionsOnly.hashCode())
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (problemType?.hashCode() ?: 0)
        result = 31 * result + (sampleWeightAttributeName?.hashCode() ?: 0)
        result = 31 * result + (targetAttributeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TabularJobConfig

        if (candidateGenerationConfig != other.candidateGenerationConfig) return false
        if (completionCriteria != other.completionCriteria) return false
        if (featureSpecificationS3Uri != other.featureSpecificationS3Uri) return false
        if (generateCandidateDefinitionsOnly != other.generateCandidateDefinitionsOnly) return false
        if (mode != other.mode) return false
        if (problemType != other.problemType) return false
        if (sampleWeightAttributeName != other.sampleWeightAttributeName) return false
        if (targetAttributeName != other.targetAttributeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TabularJobConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration information of how model candidates are generated.
         */
        public var candidateGenerationConfig: aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig? = null
        /**
         * How long a job is allowed to run, or how many candidates a job is allowed to generate.
         */
        public var completionCriteria: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria? = null
        /**
         * A URL to the Amazon S3 data source containing selected features from the input data source to run an Autopilot job V2. You can input `FeatureAttributeNames` (optional) in JSON format as shown below:
         *
         * `{ "FeatureAttributeNames":["col1", "col2", ...] }`.
         *
         * You can also specify the data type of the feature (optional) in the format shown below:
         *
         * `{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }`
         *
         * These column keys may not include the target column.
         *
         * In ensembling mode, Autopilot only supports the following data types: `numeric`, `categorical`, `text`, and `datetime`. In HPO mode, Autopilot can support `numeric`, `categorical`, `text`, `datetime`, and `sequence`.
         *
         * If only `FeatureDataTypes` is provided, the column keys (`col1`, `col2`,..) should be a subset of the column names in the input data.
         *
         * If both `FeatureDataTypes` and `FeatureAttributeNames` are provided, then the column keys should be a subset of the column names provided in `FeatureAttributeNames`.
         *
         * The key name `FeatureAttributeNames` is fixed. The values listed in `["col1", "col2", ...]` are case sensitive and should be a list of strings containing unique values that are a subset of the column names in the input data. The list of columns provided must not include the target column.
         */
        public var featureSpecificationS3Uri: kotlin.String? = null
        /**
         * Generates possible candidates without training the models. A model candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.
         */
        public var generateCandidateDefinitionsOnly: kotlin.Boolean = false
        /**
         * The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot choose for you based on the dataset size by selecting `AUTO`. In `AUTO` mode, Autopilot chooses `ENSEMBLING` for datasets smaller than 100 MB, and `HYPERPARAMETER_TUNING` for larger ones.
         *
         * The `ENSEMBLING` mode uses a multi-stack ensemble model to predict classification and regression tasks directly from your dataset. This machine learning mode combines several base models to produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions from contributing members. A multi-stack ensemble model can provide better performance over a single model by combining the predictive capabilities of multiple models. See [Autopilot algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) for a list of algorithms supported by `ENSEMBLING` mode.
         *
         * The `HYPERPARAMETER_TUNING` (HPO) mode uses the best hyperparameters to train the best version of a model. HPO automatically selects an algorithm for the type of problem you want to solve. Then HPO finds the best hyperparameters according to your objective metric. See [Autopilot algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) for a list of algorithms supported by `HYPERPARAMETER_TUNING` mode.
         */
        public var mode: aws.sdk.kotlin.services.sagemaker.model.AutoMlMode? = null
        /**
         * The type of supervised learning problem available for the model candidates of the AutoML job V2. For more information, see [ Amazon SageMaker Autopilot problem types](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types).
         *
         * You must either specify the type of supervised learning problem in `ProblemType` and provide the [AutoMLJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html#sagemaker-CreateAutoMLJobV2-request-AutoMLJobObjective) metric, or none at all.
         */
        public var problemType: aws.sdk.kotlin.services.sagemaker.model.ProblemType? = null
        /**
         * If specified, this column name indicates which column of the dataset should be treated as sample weights for use by the objective metric during the training, evaluation, and the selection of the best model. This column is not considered as a predictive feature. For more information on Autopilot metrics, see [Metrics and validation](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html).
         *
         * Sample weights should be numeric, non-negative, with larger values indicating which rows are more important than others. Data points that have invalid or no weight value are excluded.
         *
         * Support for sample weights is available in [Ensembling](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html) mode only.
         */
        public var sampleWeightAttributeName: kotlin.String? = null
        /**
         * The name of the target variable in supervised learning, usually represented by 'y'.
         */
        public var targetAttributeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TabularJobConfig) : this() {
            this.candidateGenerationConfig = x.candidateGenerationConfig
            this.completionCriteria = x.completionCriteria
            this.featureSpecificationS3Uri = x.featureSpecificationS3Uri
            this.generateCandidateDefinitionsOnly = x.generateCandidateDefinitionsOnly
            this.mode = x.mode
            this.problemType = x.problemType
            this.sampleWeightAttributeName = x.sampleWeightAttributeName
            this.targetAttributeName = x.targetAttributeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TabularJobConfig = TabularJobConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig] inside the given [block]
         */
        public fun candidateGenerationConfig(block: aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig.Builder.() -> kotlin.Unit) {
            this.candidateGenerationConfig = aws.sdk.kotlin.services.sagemaker.model.CandidateGenerationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria] inside the given [block]
         */
        public fun completionCriteria(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria.Builder.() -> kotlin.Unit) {
            this.completionCriteria = aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria.invoke(block)
        }
    }
}
