// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies a limit to how long a model training job or model compilation job can run. It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training or compilation job. Use this API to cap model training costs.
 *
 * To stop a training job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
 *
 * The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with `CreateModel`.
 *
 * The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.
 */
public class StoppingCondition private constructor(builder: Builder) {
    /**
     * The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.
     *
     * For compilation jobs, if the job does not complete during this time, a `TimeOut` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
     *
     * For all other jobs, if the job does not complete during this time, SageMaker ends the job. When `RetryStrategy` is specified in the job request, `MaxRuntimeInSeconds` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
     *
     * The maximum time that a `TrainingJob` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.
     */
    public val maxRuntimeInSeconds: kotlin.Int = builder.maxRuntimeInSeconds
    /**
     * The maximum length of time, in seconds, that a managed Spot training job has to complete. It is the amount of time spent waiting for Spot capacity plus the amount of time the job can run. It must be equal to or greater than `MaxRuntimeInSeconds`. If the job does not complete during this time, SageMaker ends the job.
     *
     * When `RetryStrategy` is specified in the job request, `MaxWaitTimeInSeconds` specifies the maximum time for all of the attempts in total, not each individual attempt.
     */
    public val maxWaitTimeInSeconds: kotlin.Int? = builder.maxWaitTimeInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.StoppingCondition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StoppingCondition(")
        append("maxRuntimeInSeconds=$maxRuntimeInSeconds,")
        append("maxWaitTimeInSeconds=$maxWaitTimeInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxRuntimeInSeconds
        result = 31 * result + (maxWaitTimeInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StoppingCondition

        if (maxRuntimeInSeconds != other.maxRuntimeInSeconds) return false
        if (maxWaitTimeInSeconds != other.maxWaitTimeInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.StoppingCondition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.
         *
         * For compilation jobs, if the job does not complete during this time, a `TimeOut` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
         *
         * For all other jobs, if the job does not complete during this time, SageMaker ends the job. When `RetryStrategy` is specified in the job request, `MaxRuntimeInSeconds` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
         *
         * The maximum time that a `TrainingJob` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.
         */
        public var maxRuntimeInSeconds: kotlin.Int = 0
        /**
         * The maximum length of time, in seconds, that a managed Spot training job has to complete. It is the amount of time spent waiting for Spot capacity plus the amount of time the job can run. It must be equal to or greater than `MaxRuntimeInSeconds`. If the job does not complete during this time, SageMaker ends the job.
         *
         * When `RetryStrategy` is specified in the job request, `MaxWaitTimeInSeconds` specifies the maximum time for all of the attempts in total, not each individual attempt.
         */
        public var maxWaitTimeInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition) : this() {
            this.maxRuntimeInSeconds = x.maxRuntimeInSeconds
            this.maxWaitTimeInSeconds = x.maxWaitTimeInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.StoppingCondition = StoppingCondition(this)
    }
}
