// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines the stairs traffic pattern for an Inference Recommender load test. This pattern type consists of multiple steps where the number of users increases at each step.
 *
 * Specify either the stairs or phases traffic pattern.
 */
public class Stairs private constructor(builder: Builder) {
    /**
     * Defines how long each traffic step should be.
     */
    public val durationInSeconds: kotlin.Int? = builder.durationInSeconds
    /**
     * Specifies how many steps to perform during traffic.
     */
    public val numberOfSteps: kotlin.Int? = builder.numberOfSteps
    /**
     * Specifies how many new users to spawn in each step.
     */
    public val usersPerStep: kotlin.Int? = builder.usersPerStep

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Stairs = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stairs(")
        append("durationInSeconds=$durationInSeconds,")
        append("numberOfSteps=$numberOfSteps,")
        append("usersPerStep=$usersPerStep")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInSeconds ?: 0
        result = 31 * result + (numberOfSteps ?: 0)
        result = 31 * result + (usersPerStep ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stairs

        if (durationInSeconds != other.durationInSeconds) return false
        if (numberOfSteps != other.numberOfSteps) return false
        if (usersPerStep != other.usersPerStep) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Stairs = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Defines how long each traffic step should be.
         */
        public var durationInSeconds: kotlin.Int? = null
        /**
         * Specifies how many steps to perform during traffic.
         */
        public var numberOfSteps: kotlin.Int? = null
        /**
         * Specifies how many new users to spawn in each step.
         */
        public var usersPerStep: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Stairs) : this() {
            this.durationInSeconds = x.durationInSeconds
            this.numberOfSteps = x.numberOfSteps
            this.usersPerStep = x.usersPerStep
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Stairs = Stairs(this)
    }
}
