// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies the S3 location of ML model data to deploy.
 */
public class S3ModelDataSource private constructor(builder: Builder) {
    /**
     * Specifies how the ML model data is prepared.
     *
     * If you choose `Gzip` and choose `S3Object` as the value of `S3DataType`, `S3Uri` identifies an object that is a gzip-compressed TAR archive. SageMaker will attempt to decompress and untar the object during model deployment.
     *
     * If you choose `None` and chooose `S3Object` as the value of `S3DataType`, `S3Uri` identifies an object that represents an uncompressed ML model to deploy.
     *
     * If you choose None and choose `S3Prefix` as the value of `S3DataType`, `S3Uri` identifies a key name prefix, under which all objects represents the uncompressed ML model to deploy.
     *
     * If you choose None, then SageMaker will follow rules below when creating model data files under /opt/ml/model directory for use by your inference code:
     * + If you choose `S3Object` as the value of `S3DataType`, then SageMaker will split the key of the S3 object referenced by `S3Uri` by slash (/), and use the last part as the filename of the file holding the content of the S3 object.
     * + If you choose `S3Prefix` as the value of `S3DataType`, then for each S3 object under the key name pefix referenced by `S3Uri`, SageMaker will trim its key by the prefix, and use the remainder as the path (relative to `/opt/ml/model`) of the file holding the content of the S3 object. SageMaker will split the remainder by slash (/), using intermediate parts as directory names and the last part as filename of the file holding the content of the S3 object.
     * + Do not use any of the following as file names or directory names:
     *    + An empty or blank string
     *    + A string which contains null bytes
     *    + A string longer than 255 bytes
     *    + A single dot (`.`)
     *    + A double dot (`..`)
     * + Ambiguous file names will result in model deployment failure. For example, if your uncompressed ML model consists of two S3 objects `s3://mybucket/model/weights` and `s3://mybucket/model/weights/part1` and you specify `s3://mybucket/model/` as the value of `S3Uri` and `S3Prefix` as the value of `S3DataType`, then it will result in name clash between `/opt/ml/model/weights` (a regular file) and `/opt/ml/model/weights/` (a directory).
     * + Do not organize the model artifacts in [S3 console using folders](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html). When you create a folder in S3 console, S3 creates a 0-byte object with a key set to the folder name you provide. They key of the 0-byte object ends with a slash (/) which violates SageMaker restrictions on model artifact file names, leading to model deployment failure.
     */
    public val compressionType: aws.sdk.kotlin.services.sagemaker.model.ModelCompressionType? = builder.compressionType
    /**
     * Specifies the type of ML model data to deploy.
     *
     * If you choose `S3Prefix`, `S3Uri` identifies a key name prefix. SageMaker uses all objects that match the specified key name prefix as part of the ML model data to deploy. A valid key name prefix identified by `S3Uri` always ends with a forward slash (/).
     *
     * If you choose `S3Object`, `S3Uri` identifies an object that is the ML model data to deploy.
     */
    public val s3DataType: aws.sdk.kotlin.services.sagemaker.model.S3ModelDataType? = builder.s3DataType
    /**
     * Specifies the S3 path of ML model data to deploy.
     */
    public val s3Uri: kotlin.String? = builder.s3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.S3ModelDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ModelDataSource(")
        append("compressionType=$compressionType,")
        append("s3DataType=$s3DataType,")
        append("s3Uri=$s3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compressionType?.hashCode() ?: 0
        result = 31 * result + (s3DataType?.hashCode() ?: 0)
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ModelDataSource

        if (compressionType != other.compressionType) return false
        if (s3DataType != other.s3DataType) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.S3ModelDataSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies how the ML model data is prepared.
         *
         * If you choose `Gzip` and choose `S3Object` as the value of `S3DataType`, `S3Uri` identifies an object that is a gzip-compressed TAR archive. SageMaker will attempt to decompress and untar the object during model deployment.
         *
         * If you choose `None` and chooose `S3Object` as the value of `S3DataType`, `S3Uri` identifies an object that represents an uncompressed ML model to deploy.
         *
         * If you choose None and choose `S3Prefix` as the value of `S3DataType`, `S3Uri` identifies a key name prefix, under which all objects represents the uncompressed ML model to deploy.
         *
         * If you choose None, then SageMaker will follow rules below when creating model data files under /opt/ml/model directory for use by your inference code:
         * + If you choose `S3Object` as the value of `S3DataType`, then SageMaker will split the key of the S3 object referenced by `S3Uri` by slash (/), and use the last part as the filename of the file holding the content of the S3 object.
         * + If you choose `S3Prefix` as the value of `S3DataType`, then for each S3 object under the key name pefix referenced by `S3Uri`, SageMaker will trim its key by the prefix, and use the remainder as the path (relative to `/opt/ml/model`) of the file holding the content of the S3 object. SageMaker will split the remainder by slash (/), using intermediate parts as directory names and the last part as filename of the file holding the content of the S3 object.
         * + Do not use any of the following as file names or directory names:
         *    + An empty or blank string
         *    + A string which contains null bytes
         *    + A string longer than 255 bytes
         *    + A single dot (`.`)
         *    + A double dot (`..`)
         * + Ambiguous file names will result in model deployment failure. For example, if your uncompressed ML model consists of two S3 objects `s3://mybucket/model/weights` and `s3://mybucket/model/weights/part1` and you specify `s3://mybucket/model/` as the value of `S3Uri` and `S3Prefix` as the value of `S3DataType`, then it will result in name clash between `/opt/ml/model/weights` (a regular file) and `/opt/ml/model/weights/` (a directory).
         * + Do not organize the model artifacts in [S3 console using folders](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html). When you create a folder in S3 console, S3 creates a 0-byte object with a key set to the folder name you provide. They key of the 0-byte object ends with a slash (/) which violates SageMaker restrictions on model artifact file names, leading to model deployment failure.
         */
        public var compressionType: aws.sdk.kotlin.services.sagemaker.model.ModelCompressionType? = null
        /**
         * Specifies the type of ML model data to deploy.
         *
         * If you choose `S3Prefix`, `S3Uri` identifies a key name prefix. SageMaker uses all objects that match the specified key name prefix as part of the ML model data to deploy. A valid key name prefix identified by `S3Uri` always ends with a forward slash (/).
         *
         * If you choose `S3Object`, `S3Uri` identifies an object that is the ML model data to deploy.
         */
        public var s3DataType: aws.sdk.kotlin.services.sagemaker.model.S3ModelDataType? = null
        /**
         * Specifies the S3 path of ML model data to deploy.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.S3ModelDataSource) : this() {
            this.compressionType = x.compressionType
            this.s3DataType = x.s3DataType
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.S3ModelDataSource = S3ModelDataSource(this)
    }
}
