// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The security configuration for `OnlineStore`.
 */
public class OnlineStoreSecurityConfig private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
     *
     * The caller (either user or IAM role) of `CreateFeatureGroup` must have below permissions to the `OnlineStore``KmsKeyId`:
     * + `"kms:Encrypt"`
     * + `"kms:Decrypt"`
     * + `"kms:DescribeKey"`
     * + `"kms:CreateGrant"`
     * + `"kms:RetireGrant"`
     * + `"kms:ReEncryptFrom"`
     * + `"kms:ReEncryptTo"`
     * + `"kms:GenerateDataKey"`
     * + `"kms:ListAliases"`
     * + `"kms:ListGrants"`
     * + `"kms:RevokeGrant"`
     *
     * The caller (either user or IAM role) to all DataPlane operations (`PutRecord`, `GetRecord`, `DeleteRecord`) must have the following permissions to the `KmsKeyId`:
     * + `"kms:Decrypt"`
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OnlineStoreSecurityConfig(")
        append("kmsKeyId=$kmsKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OnlineStoreSecurityConfig

        if (kmsKeyId != other.kmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
         *
         * The caller (either user or IAM role) of `CreateFeatureGroup` must have below permissions to the `OnlineStore``KmsKeyId`:
         * + `"kms:Encrypt"`
         * + `"kms:Decrypt"`
         * + `"kms:DescribeKey"`
         * + `"kms:CreateGrant"`
         * + `"kms:RetireGrant"`
         * + `"kms:ReEncryptFrom"`
         * + `"kms:ReEncryptTo"`
         * + `"kms:GenerateDataKey"`
         * + `"kms:ListAliases"`
         * + `"kms:ListGrants"`
         * + `"kms:RevokeGrant"`
         *
         * The caller (either user or IAM role) to all DataPlane operations (`PutRecord`, `GetRecord`, `DeleteRecord`) must have the following permissions to the `KmsKeyId`:
         * + `"kms:Decrypt"`
         */
        public var kmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig = OnlineStoreSecurityConfig(this)
    }
}
