// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or `KMSKeyId`, for at rest data encryption. You can turn `OnlineStore` on or off by specifying the `EnableOnlineStore` flag at General Assembly.
 *
 * The default value is `False`.
 */
public class OnlineStoreConfig private constructor(builder: Builder) {
    /**
     * Turn `OnlineStore` off by specifying `False` for the `EnableOnlineStore` flag. Turn `OnlineStore` on by specifying `True` for the `EnableOnlineStore` flag.
     *
     * The default value is `False`.
     */
    public val enableOnlineStore: kotlin.Boolean = builder.enableOnlineStore
    /**
     * Use to specify KMS Key ID (`KMSKeyId`) for at-rest encryption of your `OnlineStore`.
     */
    public val securityConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig? = builder.securityConfig
    /**
     * Time to live duration, where the record is hard deleted after the expiration time is reached; `ExpiresAt` = `EventTime` + `TtlDuration`. For information on HardDelete, see the [DeleteRecord](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html) API in the Amazon SageMaker API Reference guide.
     */
    public val ttlDuration: aws.sdk.kotlin.services.sagemaker.model.TtlDuration? = builder.ttlDuration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OnlineStoreConfig(")
        append("enableOnlineStore=$enableOnlineStore,")
        append("securityConfig=$securityConfig,")
        append("ttlDuration=$ttlDuration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableOnlineStore.hashCode()
        result = 31 * result + (securityConfig?.hashCode() ?: 0)
        result = 31 * result + (ttlDuration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OnlineStoreConfig

        if (enableOnlineStore != other.enableOnlineStore) return false
        if (securityConfig != other.securityConfig) return false
        if (ttlDuration != other.ttlDuration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Turn `OnlineStore` off by specifying `False` for the `EnableOnlineStore` flag. Turn `OnlineStore` on by specifying `True` for the `EnableOnlineStore` flag.
         *
         * The default value is `False`.
         */
        public var enableOnlineStore: kotlin.Boolean = false
        /**
         * Use to specify KMS Key ID (`KMSKeyId`) for at-rest encryption of your `OnlineStore`.
         */
        public var securityConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig? = null
        /**
         * Time to live duration, where the record is hard deleted after the expiration time is reached; `ExpiresAt` = `EventTime` + `TtlDuration`. For information on HardDelete, see the [DeleteRecord](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html) API in the Amazon SageMaker API Reference guide.
         */
        public var ttlDuration: aws.sdk.kotlin.services.sagemaker.model.TtlDuration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig) : this() {
            this.enableOnlineStore = x.enableOnlineStore
            this.securityConfig = x.securityConfig
            this.ttlDuration = x.ttlDuration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig = OnlineStoreConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig] inside the given [block]
         */
        public fun securityConfig(block: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig.Builder.() -> kotlin.Unit) {
            this.securityConfig = aws.sdk.kotlin.services.sagemaker.model.OnlineStoreSecurityConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TtlDuration] inside the given [block]
         */
        public fun ttlDuration(block: aws.sdk.kotlin.services.sagemaker.model.TtlDuration.Builder.() -> kotlin.Unit) {
            this.ttlDuration = aws.sdk.kotlin.services.sagemaker.model.TtlDuration.invoke(block)
        }
    }
}
