// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
 */
public class NetworkConfig private constructor(builder: Builder) {
    /**
     * Whether to encrypt all communications between distributed processing jobs. Choose `True` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
     */
    public val enableInterContainerTrafficEncryption: kotlin.Boolean = builder.enableInterContainerTrafficEncryption
    /**
     * Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
     */
    public val enableNetworkIsolation: kotlin.Boolean = builder.enableNetworkIsolation
    /**
     * Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.NetworkConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkConfig(")
        append("enableInterContainerTrafficEncryption=$enableInterContainerTrafficEncryption,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableInterContainerTrafficEncryption.hashCode()
        result = 31 * result + (enableNetworkIsolation.hashCode())
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkConfig

        if (enableInterContainerTrafficEncryption != other.enableInterContainerTrafficEncryption) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.NetworkConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether to encrypt all communications between distributed processing jobs. Choose `True` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
         */
        public var enableInterContainerTrafficEncryption: kotlin.Boolean = false
        /**
         * Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
         */
        public var enableNetworkIsolation: kotlin.Boolean = false
        /**
         * Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig) : this() {
            this.enableInterContainerTrafficEncryption = x.enableInterContainerTrafficEncryption
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.NetworkConfig = NetworkConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }
    }
}
