// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The Amazon SageMaker Canvas app setting where you configure OAuth for connecting to an external data source, such as Snowflake.
 */
public class IdentityProviderOAuthSetting private constructor(builder: Builder) {
    /**
     * The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and Salesforce Data Cloud.
     */
    public val dataSourceName: aws.sdk.kotlin.services.sagemaker.model.DataSourceName? = builder.dataSourceName
    /**
     * The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity provider, such as the client ID and secret, authorization URL, and token URL.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.FeatureStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.IdentityProviderOAuthSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityProviderOAuthSetting(")
        append("dataSourceName=$dataSourceName,")
        append("secretArn=$secretArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceName?.hashCode() ?: 0
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityProviderOAuthSetting

        if (dataSourceName != other.dataSourceName) return false
        if (secretArn != other.secretArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.IdentityProviderOAuthSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and Salesforce Data Cloud.
         */
        public var dataSourceName: aws.sdk.kotlin.services.sagemaker.model.DataSourceName? = null
        /**
         * The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity provider, such as the client ID and secret, authorization URL, and token URL.
         */
        public var secretArn: kotlin.String? = null
        /**
         * Describes whether OAuth for a data source is enabled or disabled in the Canvas application.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.FeatureStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.IdentityProviderOAuthSetting) : this() {
            this.dataSourceName = x.dataSourceName
            this.secretArn = x.secretArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.IdentityProviderOAuthSetting = IdentityProviderOAuthSetting(this)
    }
}
