// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The configuration of resources, including compute instances and storage volumes for use in training jobs launched by hyperparameter tuning jobs. `HyperParameterTuningResourceConfig` is similar to `ResourceConfig`, but has the additional `InstanceConfigs` and `AllocationStrategy` fields to allow for flexible instance management. Specify one or more instance types, count, and the allocation strategy for instance selection.
 *
 * `HyperParameterTuningResourceConfig` supports the capabilities of `ResourceConfig` with the exception of `KeepAlivePeriodInSeconds`. Hyperparameter tuning jobs use warm pools by default, which reuse clusters between training jobs.
 */
public class HyperParameterTuningResourceConfig private constructor(builder: Builder) {
    /**
     * The strategy that determines the order of preference for resources specified in `InstanceConfigs` used in hyperparameter optimization.
     */
    public val allocationStrategy: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningAllocationStrategy? = builder.allocationStrategy
    /**
     * A list containing the configuration(s) for one or more resources for processing hyperparameter jobs. These resources include compute instances and storage volumes to use in model training jobs launched by hyperparameter tuning jobs. The `AllocationStrategy` controls the order in which multiple configurations provided in `InstanceConfigs` are used.
     *
     * If you only want to use a single instance configuration inside the `HyperParameterTuningResourceConfig` API, do not provide a value for `InstanceConfigs`. Instead, use `InstanceType`, `VolumeSizeInGB` and `InstanceCount`. If you use `InstanceConfigs`, do not provide values for `InstanceType`, `VolumeSizeInGB` or `InstanceCount`.
     */
    public val instanceConfigs: List<HyperParameterTuningInstanceConfig>? = builder.instanceConfigs
    /**
     * The number of compute instances of type `InstanceType` to use. For [distributed training](https://docs.aws.amazon.com/sagemaker/latest/dg/data-parallel-use-api.html), select a value greater than 1.
     */
    public val instanceCount: kotlin.Int = builder.instanceCount
    /**
     * The instance type used to run hyperparameter optimization tuning jobs. See [ descriptions of instance types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html) for more information.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.TrainingInstanceType? = builder.instanceType
    /**
     * A key used by Amazon Web Services Key Management Service to encrypt data on the storage volume attached to the compute instances used to run the training job. You can use either of the following formats to specify a key.
     *
     * KMS Key ID:
     *
     * `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     *
     * Amazon Resource Name (ARN) of a KMS key:
     *
     * `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     *
     * Some instances use local storage, which use a [hardware module to encrypt](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html) storage volumes. If you choose one of these instance types, you cannot request a `VolumeKmsKeyId`. For a list of instance types that use local storage, see [instance store volumes](http://aws.amazon.com/releasenotes/host-instance-storage-volumes-table/). For more information about Amazon Web Services Key Management Service, see [KMS encryption](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-kms-permissions.html) for more information.
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * The volume size in GB for the storage volume to be used in processing hyperparameter optimization jobs (optional). These volumes store model artifacts, incremental states and optionally, scratch space for training algorithms. Do not provide a value for this parameter if a value for `InstanceConfigs` is also specified.
     *
     * Some instance types have a fixed total local storage size. If you select one of these instances for training, `VolumeSizeInGB` cannot be greater than this total size. For a list of instance types with local instance storage and their sizes, see [instance store volumes](http://aws.amazon.com/releasenotes/host-instance-storage-volumes-table/).
     *
     * SageMaker supports only the [General Purpose SSD (gp2)](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html) storage volume type.
     */
    public val volumeSizeInGb: kotlin.Int = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningResourceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterTuningResourceConfig(")
        append("allocationStrategy=$allocationStrategy,")
        append("instanceConfigs=$instanceConfigs,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (instanceConfigs?.hashCode() ?: 0)
        result = 31 * result + (instanceCount)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterTuningResourceConfig

        if (allocationStrategy != other.allocationStrategy) return false
        if (instanceConfigs != other.instanceConfigs) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningResourceConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The strategy that determines the order of preference for resources specified in `InstanceConfigs` used in hyperparameter optimization.
         */
        public var allocationStrategy: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningAllocationStrategy? = null
        /**
         * A list containing the configuration(s) for one or more resources for processing hyperparameter jobs. These resources include compute instances and storage volumes to use in model training jobs launched by hyperparameter tuning jobs. The `AllocationStrategy` controls the order in which multiple configurations provided in `InstanceConfigs` are used.
         *
         * If you only want to use a single instance configuration inside the `HyperParameterTuningResourceConfig` API, do not provide a value for `InstanceConfigs`. Instead, use `InstanceType`, `VolumeSizeInGB` and `InstanceCount`. If you use `InstanceConfigs`, do not provide values for `InstanceType`, `VolumeSizeInGB` or `InstanceCount`.
         */
        public var instanceConfigs: List<HyperParameterTuningInstanceConfig>? = null
        /**
         * The number of compute instances of type `InstanceType` to use. For [distributed training](https://docs.aws.amazon.com/sagemaker/latest/dg/data-parallel-use-api.html), select a value greater than 1.
         */
        public var instanceCount: kotlin.Int = 0
        /**
         * The instance type used to run hyperparameter optimization tuning jobs. See [ descriptions of instance types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html) for more information.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.TrainingInstanceType? = null
        /**
         * A key used by Amazon Web Services Key Management Service to encrypt data on the storage volume attached to the compute instances used to run the training job. You can use either of the following formats to specify a key.
         *
         * KMS Key ID:
         *
         * `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         *
         * Amazon Resource Name (ARN) of a KMS key:
         *
         * `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         *
         * Some instances use local storage, which use a [hardware module to encrypt](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html) storage volumes. If you choose one of these instance types, you cannot request a `VolumeKmsKeyId`. For a list of instance types that use local storage, see [instance store volumes](http://aws.amazon.com/releasenotes/host-instance-storage-volumes-table/). For more information about Amazon Web Services Key Management Service, see [KMS encryption](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-kms-permissions.html) for more information.
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * The volume size in GB for the storage volume to be used in processing hyperparameter optimization jobs (optional). These volumes store model artifacts, incremental states and optionally, scratch space for training algorithms. Do not provide a value for this parameter if a value for `InstanceConfigs` is also specified.
         *
         * Some instance types have a fixed total local storage size. If you select one of these instances for training, `VolumeSizeInGB` cannot be greater than this total size. For a list of instance types with local instance storage and their sizes, see [instance store volumes](http://aws.amazon.com/releasenotes/host-instance-storage-volumes-table/).
         *
         * SageMaker supports only the [General Purpose SSD (gp2)](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html) storage volume type.
         */
        public var volumeSizeInGb: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningResourceConfig) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.instanceConfigs = x.instanceConfigs
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningResourceConfig = HyperParameterTuningResourceConfig(this)
    }
}
