// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines under what conditions SageMaker creates a human loop. Used within [CreateFlowDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateFlowDefinition.html). See [HumanLoopActivationConditionsConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HumanLoopActivationConditionsConfig.html) for the required format of activation conditions.
 */
public class HumanLoopActivationConditionsConfig private constructor(builder: Builder) {
    /**
     * JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. The set of conditions is different for Rekognition and Textract. For more information about how to structure the JSON, see [JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html) in the *Amazon SageMaker Developer Guide*.
     */
    public val humanLoopActivationConditions: kotlin.String? = builder.humanLoopActivationConditions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConditionsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HumanLoopActivationConditionsConfig(")
        append("humanLoopActivationConditions=$humanLoopActivationConditions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = humanLoopActivationConditions?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HumanLoopActivationConditionsConfig

        if (humanLoopActivationConditions != other.humanLoopActivationConditions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConditionsConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. The set of conditions is different for Rekognition and Textract. For more information about how to structure the JSON, see [JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html) in the *Amazon SageMaker Developer Guide*.
         */
        public var humanLoopActivationConditions: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConditionsConfig) : this() {
            this.humanLoopActivationConditions = x.humanLoopActivationConditions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConditionsConfig = HumanLoopActivationConditionsConfig(this)
    }
}
