// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
 */
public class FileSystemConfig private constructor(builder: Builder) {
    /**
     * The default POSIX group ID (GID). If not specified, defaults to `100`.
     */
    public val defaultGid: kotlin.Int? = builder.defaultGid
    /**
     * The default POSIX user ID (UID). If not specified, defaults to `1000`.
     */
    public val defaultUid: kotlin.Int? = builder.defaultUid
    /**
     * The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to *&#47;home/sagemaker-user*.
     */
    public val mountPath: kotlin.String? = builder.mountPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.FileSystemConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystemConfig(")
        append("defaultGid=$defaultGid,")
        append("defaultUid=$defaultUid,")
        append("mountPath=$mountPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultGid ?: 0
        result = 31 * result + (defaultUid ?: 0)
        result = 31 * result + (mountPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileSystemConfig

        if (defaultGid != other.defaultGid) return false
        if (defaultUid != other.defaultUid) return false
        if (mountPath != other.mountPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.FileSystemConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default POSIX group ID (GID). If not specified, defaults to `100`.
         */
        public var defaultGid: kotlin.Int? = null
        /**
         * The default POSIX user ID (UID). If not specified, defaults to `1000`.
         */
        public var defaultUid: kotlin.Int? = null
        /**
         * The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to *&#47;home/sagemaker-user*.
         */
        public var mountPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.FileSystemConfig) : this() {
            this.defaultGid = x.defaultGid
            this.defaultUid = x.defaultUid
            this.mountPath = x.mountPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.FileSystemConfig = FileSystemConfig(this)
    }
}
