// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The properties of an experiment as returned by the [Search](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html) API.
 */
public class Experiment private constructor(builder: Builder) {
    /**
     * Who created the experiment.
     */
    public val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * When the experiment was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the experiment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the experiment as displayed. If `DisplayName` isn't specified, `ExperimentName` is displayed.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The Amazon Resource Name (ARN) of the experiment.
     */
    public val experimentArn: kotlin.String? = builder.experimentArn
    /**
     * The name of the experiment.
     */
    public val experimentName: kotlin.String? = builder.experimentName
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * When the experiment was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The source of the experiment.
     */
    public val source: aws.sdk.kotlin.services.sagemaker.model.ExperimentSource? = builder.source
    /**
     * The list of tags that are associated with the experiment. You can use [Search](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html) API to search on the tags.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Experiment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Experiment(")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("experimentArn=$experimentArn,")
        append("experimentName=$experimentName,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("source=$source,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (experimentArn?.hashCode() ?: 0)
        result = 31 * result + (experimentName?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Experiment

        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (experimentArn != other.experimentArn) return false
        if (experimentName != other.experimentName) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (source != other.source) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Experiment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Who created the experiment.
         */
        public var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * When the experiment was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the experiment.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the experiment as displayed. If `DisplayName` isn't specified, `ExperimentName` is displayed.
         */
        public var displayName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the experiment.
         */
        public var experimentArn: kotlin.String? = null
        /**
         * The name of the experiment.
         */
        public var experimentName: kotlin.String? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * When the experiment was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The source of the experiment.
         */
        public var source: aws.sdk.kotlin.services.sagemaker.model.ExperimentSource? = null
        /**
         * The list of tags that are associated with the experiment. You can use [Search](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html) API to search on the tags.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Experiment) : this() {
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.description = x.description
            this.displayName = x.displayName
            this.experimentArn = x.experimentArn
            this.experimentName = x.experimentName
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.source = x.source
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Experiment = Experiment(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExperimentSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.sagemaker.model.ExperimentSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.sagemaker.model.ExperimentSource.invoke(block)
        }
    }
}
