// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information summarizing device details and deployment status.
 */
public class DeviceDeploymentSummary private constructor(builder: Builder) {
    /**
     * The name of the deployed stage.
     */
    public val deployedStageName: kotlin.String? = builder.deployedStageName
    /**
     * The time when the deployment on the device started.
     */
    public val deploymentStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deploymentStartTime
    /**
     * The description of the device.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the device.
     */
    public val deviceArn: kotlin.String? = builder.deviceArn
    /**
     * The deployment status of the device.
     */
    public val deviceDeploymentStatus: aws.sdk.kotlin.services.sagemaker.model.DeviceDeploymentStatus? = builder.deviceDeploymentStatus
    /**
     * The detailed error message for the deployoment status result.
     */
    public val deviceDeploymentStatusMessage: kotlin.String? = builder.deviceDeploymentStatusMessage
    /**
     * The name of the fleet to which the device belongs to.
     */
    public val deviceFleetName: kotlin.String? = builder.deviceFleetName
    /**
     * The name of the device.
     */
    public val deviceName: kotlin.String? = builder.deviceName
    /**
     * The ARN of the edge deployment plan.
     */
    public val edgeDeploymentPlanArn: kotlin.String? = builder.edgeDeploymentPlanArn
    /**
     * The name of the edge deployment plan.
     */
    public val edgeDeploymentPlanName: kotlin.String? = builder.edgeDeploymentPlanName
    /**
     * The name of the stage in the edge deployment plan.
     */
    public val stageName: kotlin.String? = builder.stageName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DeviceDeploymentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceDeploymentSummary(")
        append("deployedStageName=$deployedStageName,")
        append("deploymentStartTime=$deploymentStartTime,")
        append("description=$description,")
        append("deviceArn=$deviceArn,")
        append("deviceDeploymentStatus=$deviceDeploymentStatus,")
        append("deviceDeploymentStatusMessage=$deviceDeploymentStatusMessage,")
        append("deviceFleetName=$deviceFleetName,")
        append("deviceName=$deviceName,")
        append("edgeDeploymentPlanArn=$edgeDeploymentPlanArn,")
        append("edgeDeploymentPlanName=$edgeDeploymentPlanName,")
        append("stageName=$stageName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deployedStageName?.hashCode() ?: 0
        result = 31 * result + (deploymentStartTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceArn?.hashCode() ?: 0)
        result = 31 * result + (deviceDeploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (deviceDeploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (deviceFleetName?.hashCode() ?: 0)
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (edgeDeploymentPlanArn?.hashCode() ?: 0)
        result = 31 * result + (edgeDeploymentPlanName?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeviceDeploymentSummary

        if (deployedStageName != other.deployedStageName) return false
        if (deploymentStartTime != other.deploymentStartTime) return false
        if (description != other.description) return false
        if (deviceArn != other.deviceArn) return false
        if (deviceDeploymentStatus != other.deviceDeploymentStatus) return false
        if (deviceDeploymentStatusMessage != other.deviceDeploymentStatusMessage) return false
        if (deviceFleetName != other.deviceFleetName) return false
        if (deviceName != other.deviceName) return false
        if (edgeDeploymentPlanArn != other.edgeDeploymentPlanArn) return false
        if (edgeDeploymentPlanName != other.edgeDeploymentPlanName) return false
        if (stageName != other.stageName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DeviceDeploymentSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the deployed stage.
         */
        public var deployedStageName: kotlin.String? = null
        /**
         * The time when the deployment on the device started.
         */
        public var deploymentStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the device.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the device.
         */
        public var deviceArn: kotlin.String? = null
        /**
         * The deployment status of the device.
         */
        public var deviceDeploymentStatus: aws.sdk.kotlin.services.sagemaker.model.DeviceDeploymentStatus? = null
        /**
         * The detailed error message for the deployoment status result.
         */
        public var deviceDeploymentStatusMessage: kotlin.String? = null
        /**
         * The name of the fleet to which the device belongs to.
         */
        public var deviceFleetName: kotlin.String? = null
        /**
         * The name of the device.
         */
        public var deviceName: kotlin.String? = null
        /**
         * The ARN of the edge deployment plan.
         */
        public var edgeDeploymentPlanArn: kotlin.String? = null
        /**
         * The name of the edge deployment plan.
         */
        public var edgeDeploymentPlanName: kotlin.String? = null
        /**
         * The name of the stage in the edge deployment plan.
         */
        public var stageName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DeviceDeploymentSummary) : this() {
            this.deployedStageName = x.deployedStageName
            this.deploymentStartTime = x.deploymentStartTime
            this.description = x.description
            this.deviceArn = x.deviceArn
            this.deviceDeploymentStatus = x.deviceDeploymentStatus
            this.deviceDeploymentStatusMessage = x.deviceDeploymentStatusMessage
            this.deviceFleetName = x.deviceFleetName
            this.deviceName = x.deviceName
            this.edgeDeploymentPlanArn = x.edgeDeploymentPlanArn
            this.edgeDeploymentPlanName = x.edgeDeploymentPlanName
            this.stageName = x.stageName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DeviceDeploymentSummary = DeviceDeploymentSummary(this)
    }
}
