// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeModelCardResponse private constructor(builder: Builder) {
    /**
     * The content of the model card.
     */
    public val content: kotlin.String? = builder.content
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * The date and time the model card was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * The date and time the model card was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the model card.
     */
    public val modelCardArn: kotlin.String? = builder.modelCardArn
    /**
     * The name of the model card.
     */
    public val modelCardName: kotlin.String? = builder.modelCardName
    /**
     * The processing status of model card deletion. The `ModelCardProcessingStatus` updates throughout the different deletion steps.
     * + `DeletePending`: Model card deletion request received.
     * + `DeleteInProgress`: Model card deletion is in progress.
     * + `ContentDeleted`: Deleted model card content.
     * + `ExportJobsDeleted`: Deleted all export jobs associated with the model card.
     * + `DeleteCompleted`: Successfully deleted the model card.
     * + `DeleteFailed`: The model card failed to delete.
     */
    public val modelCardProcessingStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardProcessingStatus? = builder.modelCardProcessingStatus
    /**
     * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
     * + `Draft`: The model card is a work in progress.
     * + `PendingReview`: The model card is pending review.
     * + `Approved`: The model card is approved.
     * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
     */
    public val modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = builder.modelCardStatus
    /**
     * The version of the model card.
     */
    public val modelCardVersion: kotlin.Int = builder.modelCardVersion
    /**
     * The security configuration used to protect model card content.
     */
    public val securityConfig: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig? = builder.securityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeModelCardResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeModelCardResponse(")
        append("content=*** Sensitive Data Redacted ***,")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelCardArn=$modelCardArn,")
        append("modelCardName=$modelCardName,")
        append("modelCardProcessingStatus=$modelCardProcessingStatus,")
        append("modelCardStatus=$modelCardStatus,")
        append("modelCardVersion=$modelCardVersion,")
        append("securityConfig=$securityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelCardArn?.hashCode() ?: 0)
        result = 31 * result + (modelCardName?.hashCode() ?: 0)
        result = 31 * result + (modelCardProcessingStatus?.hashCode() ?: 0)
        result = 31 * result + (modelCardStatus?.hashCode() ?: 0)
        result = 31 * result + (modelCardVersion)
        result = 31 * result + (securityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeModelCardResponse

        if (content != other.content) return false
        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelCardArn != other.modelCardArn) return false
        if (modelCardName != other.modelCardName) return false
        if (modelCardProcessingStatus != other.modelCardProcessingStatus) return false
        if (modelCardStatus != other.modelCardStatus) return false
        if (modelCardVersion != other.modelCardVersion) return false
        if (securityConfig != other.securityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeModelCardResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The content of the model card.
         */
        public var content: kotlin.String? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The date and time the model card was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The date and time the model card was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the model card.
         */
        public var modelCardArn: kotlin.String? = null
        /**
         * The name of the model card.
         */
        public var modelCardName: kotlin.String? = null
        /**
         * The processing status of model card deletion. The `ModelCardProcessingStatus` updates throughout the different deletion steps.
         * + `DeletePending`: Model card deletion request received.
         * + `DeleteInProgress`: Model card deletion is in progress.
         * + `ContentDeleted`: Deleted model card content.
         * + `ExportJobsDeleted`: Deleted all export jobs associated with the model card.
         * + `DeleteCompleted`: Successfully deleted the model card.
         * + `DeleteFailed`: The model card failed to delete.
         */
        public var modelCardProcessingStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardProcessingStatus? = null
        /**
         * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
         * + `Draft`: The model card is a work in progress.
         * + `PendingReview`: The model card is pending review.
         * + `Approved`: The model card is approved.
         * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
         */
        public var modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = null
        /**
         * The version of the model card.
         */
        public var modelCardVersion: kotlin.Int = 0
        /**
         * The security configuration used to protect model card content.
         */
        public var securityConfig: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeModelCardResponse) : this() {
            this.content = x.content
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.modelCardArn = x.modelCardArn
            this.modelCardName = x.modelCardName
            this.modelCardProcessingStatus = x.modelCardProcessingStatus
            this.modelCardStatus = x.modelCardStatus
            this.modelCardVersion = x.modelCardVersion
            this.securityConfig = x.securityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeModelCardResponse = DescribeModelCardResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig] inside the given [block]
         */
        public fun securityConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig.Builder.() -> kotlin.Unit) {
            this.securityConfig = aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig.invoke(block)
        }
    }
}
