// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateTrainingJobRequest private constructor(builder: Builder) {
    /**
     * The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata, including the input mode. For more information about algorithms provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information about providing your own algorithms, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
     */
    public val algorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification? = builder.algorithmSpecification
    /**
     * Contains information about the output location for managed spot training checkpoint data.
     */
    public val checkpointConfig: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig? = builder.checkpointConfig
    /**
     * Configuration information for the Amazon SageMaker Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the `DebugHookConfig` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
     */
    public val debugHookConfig: aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig? = builder.debugHookConfig
    /**
     * Configuration information for Amazon SageMaker Debugger rules for debugging output tensors.
     */
    public val debugRuleConfigurations: List<DebugRuleConfiguration>? = builder.debugRuleConfigurations
    /**
     * To encrypt all communications between ML compute instances in distributed training, choose `True`. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training. For more information, see [Protect Communications Between ML Compute Instances in a Distributed Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html).
     */
    public val enableInterContainerTrafficEncryption: kotlin.Boolean = builder.enableInterContainerTrafficEncryption
    /**
     * To train models using managed spot training, choose `True`. Managed spot training provides a fully managed and scalable infrastructure for training machine learning models. this option is useful when training jobs can be interrupted and when there is flexibility when the training job is run.
     *
     * The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed.
     */
    public val enableManagedSpotTraining: kotlin.Boolean = builder.enableManagedSpotTraining
    /**
     * Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If you enable network isolation for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.
     */
    public val enableNetworkIsolation: kotlin.Boolean = builder.enableNetworkIsolation
    /**
     * The environment variables to set in the Docker container.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
     * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
     * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
     * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
     */
    public val experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = builder.experimentConfig
    /**
     * Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process. For a list of hyperparameters for each training algorithm provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
     *
     * You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is limited to 256 characters, as specified by the `Length Constraint`.
     *
     * Do not include any security-sensitive information including account access IDs, secrets or tokens in any hyperparameter field. If the use of security-sensitive credentials are detected, SageMaker will reject your training job request and return an exception error.
     */
    public val hyperParameters: Map<String, String>? = builder.hyperParameters
    /**
     * An array of `Channel` objects. Each channel is a named input source. `InputDataConfig` describes the input data and its location.
     *
     * Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of input data, `training_data` and `validation_data`. The configuration for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format.
     *
     * Depending on the input mode that the algorithm supports, SageMaker either copies input data files from an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if you specify an EFS location, input data files are available as input streams. They do not need to be downloaded.
     *
     * Your input must be in the same Amazon Web Services region as your training job.
     */
    public val inputDataConfig: List<Channel>? = builder.inputDataConfig
    /**
     * Specifies the path to the S3 location where you want to store model artifacts. SageMaker creates subfolders for the artifacts.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * Configuration information for Amazon SageMaker Debugger system monitoring, framework profiling, and storage paths.
     */
    public val profilerConfig: aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig? = builder.profilerConfig
    /**
     * Configuration information for Amazon SageMaker Debugger rules for profiling system and framework metrics.
     */
    public val profilerRuleConfigurations: List<ProfilerRuleConfiguration>? = builder.profilerRuleConfigurations
    /**
     * The resources, including the ML compute instances and ML storage volumes, to use for model training.
     *
     * ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML storage volumes for scratch space. If you want SageMaker to use the ML storage volume to store the training data, choose `File` as the `TrainingInputMode` in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.
     */
    public val resourceConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig? = builder.resourceConfig
    /**
     * The number of times to retry the job when the job fails due to an `InternalServerError`.
     */
    public val retryStrategy: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy? = builder.retryStrategy
    /**
     * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf.
     *
     * During model training, SageMaker needs your permission to read input data from an S3 bucket, download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an IAM role. For more information, see [SageMaker Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
     *
     * To be able to pass this role to SageMaker, the caller of this API must have the `iam:PassRole` permission.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this API to cap model training costs.
     *
     * To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = builder.stoppingCondition
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Configuration of storage locations for the Amazon SageMaker Debugger TensorBoard output data.
     */
    public val tensorBoardOutputConfig: aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig? = builder.tensorBoardOutputConfig
    /**
     * The name of the training job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
     */
    public val trainingJobName: kotlin.String? = builder.trainingJobName
    /**
     * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html) object that specifies the VPC that you want your training job to connect to. Control access to and from your training container by configuring the VPC. For more information, see [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateTrainingJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrainingJobRequest(")
        append("algorithmSpecification=$algorithmSpecification,")
        append("checkpointConfig=$checkpointConfig,")
        append("debugHookConfig=$debugHookConfig,")
        append("debugRuleConfigurations=$debugRuleConfigurations,")
        append("enableInterContainerTrafficEncryption=$enableInterContainerTrafficEncryption,")
        append("enableManagedSpotTraining=$enableManagedSpotTraining,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("environment=$environment,")
        append("experimentConfig=$experimentConfig,")
        append("hyperParameters=$hyperParameters,")
        append("inputDataConfig=$inputDataConfig,")
        append("outputDataConfig=$outputDataConfig,")
        append("profilerConfig=$profilerConfig,")
        append("profilerRuleConfigurations=$profilerRuleConfigurations,")
        append("resourceConfig=$resourceConfig,")
        append("retryStrategy=$retryStrategy,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("tags=$tags,")
        append("tensorBoardOutputConfig=$tensorBoardOutputConfig,")
        append("trainingJobName=$trainingJobName,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmSpecification?.hashCode() ?: 0
        result = 31 * result + (checkpointConfig?.hashCode() ?: 0)
        result = 31 * result + (debugHookConfig?.hashCode() ?: 0)
        result = 31 * result + (debugRuleConfigurations?.hashCode() ?: 0)
        result = 31 * result + (enableInterContainerTrafficEncryption.hashCode())
        result = 31 * result + (enableManagedSpotTraining.hashCode())
        result = 31 * result + (enableNetworkIsolation.hashCode())
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (experimentConfig?.hashCode() ?: 0)
        result = 31 * result + (hyperParameters?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (profilerConfig?.hashCode() ?: 0)
        result = 31 * result + (profilerRuleConfigurations?.hashCode() ?: 0)
        result = 31 * result + (resourceConfig?.hashCode() ?: 0)
        result = 31 * result + (retryStrategy?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tensorBoardOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (trainingJobName?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrainingJobRequest

        if (algorithmSpecification != other.algorithmSpecification) return false
        if (checkpointConfig != other.checkpointConfig) return false
        if (debugHookConfig != other.debugHookConfig) return false
        if (debugRuleConfigurations != other.debugRuleConfigurations) return false
        if (enableInterContainerTrafficEncryption != other.enableInterContainerTrafficEncryption) return false
        if (enableManagedSpotTraining != other.enableManagedSpotTraining) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (environment != other.environment) return false
        if (experimentConfig != other.experimentConfig) return false
        if (hyperParameters != other.hyperParameters) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (profilerConfig != other.profilerConfig) return false
        if (profilerRuleConfigurations != other.profilerRuleConfigurations) return false
        if (resourceConfig != other.resourceConfig) return false
        if (retryStrategy != other.retryStrategy) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tags != other.tags) return false
        if (tensorBoardOutputConfig != other.tensorBoardOutputConfig) return false
        if (trainingJobName != other.trainingJobName) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateTrainingJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata, including the input mode. For more information about algorithms provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information about providing your own algorithms, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
         */
        public var algorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification? = null
        /**
         * Contains information about the output location for managed spot training checkpoint data.
         */
        public var checkpointConfig: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig? = null
        /**
         * Configuration information for the Amazon SageMaker Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the `DebugHookConfig` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
         */
        public var debugHookConfig: aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig? = null
        /**
         * Configuration information for Amazon SageMaker Debugger rules for debugging output tensors.
         */
        public var debugRuleConfigurations: List<DebugRuleConfiguration>? = null
        /**
         * To encrypt all communications between ML compute instances in distributed training, choose `True`. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training. For more information, see [Protect Communications Between ML Compute Instances in a Distributed Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html).
         */
        public var enableInterContainerTrafficEncryption: kotlin.Boolean = false
        /**
         * To train models using managed spot training, choose `True`. Managed spot training provides a fully managed and scalable infrastructure for training machine learning models. this option is useful when training jobs can be interrupted and when there is flexibility when the training job is run.
         *
         * The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed.
         */
        public var enableManagedSpotTraining: kotlin.Boolean = false
        /**
         * Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If you enable network isolation for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.
         */
        public var enableNetworkIsolation: kotlin.Boolean = false
        /**
         * The environment variables to set in the Docker container.
         */
        public var environment: Map<String, String>? = null
        /**
         * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
         * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
         * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
         * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
         */
        public var experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = null
        /**
         * Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process. For a list of hyperparameters for each training algorithm provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
         *
         * You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is limited to 256 characters, as specified by the `Length Constraint`.
         *
         * Do not include any security-sensitive information including account access IDs, secrets or tokens in any hyperparameter field. If the use of security-sensitive credentials are detected, SageMaker will reject your training job request and return an exception error.
         */
        public var hyperParameters: Map<String, String>? = null
        /**
         * An array of `Channel` objects. Each channel is a named input source. `InputDataConfig` describes the input data and its location.
         *
         * Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of input data, `training_data` and `validation_data`. The configuration for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format.
         *
         * Depending on the input mode that the algorithm supports, SageMaker either copies input data files from an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if you specify an EFS location, input data files are available as input streams. They do not need to be downloaded.
         *
         * Your input must be in the same Amazon Web Services region as your training job.
         */
        public var inputDataConfig: List<Channel>? = null
        /**
         * Specifies the path to the S3 location where you want to store model artifacts. SageMaker creates subfolders for the artifacts.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig? = null
        /**
         * Configuration information for Amazon SageMaker Debugger system monitoring, framework profiling, and storage paths.
         */
        public var profilerConfig: aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig? = null
        /**
         * Configuration information for Amazon SageMaker Debugger rules for profiling system and framework metrics.
         */
        public var profilerRuleConfigurations: List<ProfilerRuleConfiguration>? = null
        /**
         * The resources, including the ML compute instances and ML storage volumes, to use for model training.
         *
         * ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML storage volumes for scratch space. If you want SageMaker to use the ML storage volume to store the training data, choose `File` as the `TrainingInputMode` in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.
         */
        public var resourceConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig? = null
        /**
         * The number of times to retry the job when the job fails due to an `InternalServerError`.
         */
        public var retryStrategy: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf.
         *
         * During model training, SageMaker needs your permission to read input data from an S3 bucket, download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an IAM role. For more information, see [SageMaker Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
         *
         * To be able to pass this role to SageMaker, the caller of this API must have the `iam:PassRole` permission.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this API to cap model training costs.
         *
         * To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * Configuration of storage locations for the Amazon SageMaker Debugger TensorBoard output data.
         */
        public var tensorBoardOutputConfig: aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig? = null
        /**
         * The name of the training job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
         */
        public var trainingJobName: kotlin.String? = null
        /**
         * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html) object that specifies the VPC that you want your training job to connect to. Control access to and from your training container by configuring the VPC. For more information, see [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateTrainingJobRequest) : this() {
            this.algorithmSpecification = x.algorithmSpecification
            this.checkpointConfig = x.checkpointConfig
            this.debugHookConfig = x.debugHookConfig
            this.debugRuleConfigurations = x.debugRuleConfigurations
            this.enableInterContainerTrafficEncryption = x.enableInterContainerTrafficEncryption
            this.enableManagedSpotTraining = x.enableManagedSpotTraining
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.environment = x.environment
            this.experimentConfig = x.experimentConfig
            this.hyperParameters = x.hyperParameters
            this.inputDataConfig = x.inputDataConfig
            this.outputDataConfig = x.outputDataConfig
            this.profilerConfig = x.profilerConfig
            this.profilerRuleConfigurations = x.profilerRuleConfigurations
            this.resourceConfig = x.resourceConfig
            this.retryStrategy = x.retryStrategy
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.tags = x.tags
            this.tensorBoardOutputConfig = x.tensorBoardOutputConfig
            this.trainingJobName = x.trainingJobName
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateTrainingJobRequest = CreateTrainingJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification] inside the given [block]
         */
        public fun algorithmSpecification(block: aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.algorithmSpecification = aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig] inside the given [block]
         */
        public fun checkpointConfig(block: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig.Builder.() -> kotlin.Unit) {
            this.checkpointConfig = aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig] inside the given [block]
         */
        public fun debugHookConfig(block: aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig.Builder.() -> kotlin.Unit) {
            this.debugHookConfig = aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig] inside the given [block]
         */
        public fun experimentConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.Builder.() -> kotlin.Unit) {
            this.experimentConfig = aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig] inside the given [block]
         */
        public fun profilerConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig.Builder.() -> kotlin.Unit) {
            this.profilerConfig = aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceConfig] inside the given [block]
         */
        public fun resourceConfig(block: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig.Builder.() -> kotlin.Unit) {
            this.resourceConfig = aws.sdk.kotlin.services.sagemaker.model.ResourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RetryStrategy] inside the given [block]
         */
        public fun retryStrategy(block: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy.Builder.() -> kotlin.Unit) {
            this.retryStrategy = aws.sdk.kotlin.services.sagemaker.model.RetryStrategy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.StoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig] inside the given [block]
         */
        public fun tensorBoardOutputConfig(block: aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig.Builder.() -> kotlin.Unit) {
            this.tensorBoardOutputConfig = aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }
    }
}
