// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateHyperParameterTuningJobRequest private constructor(builder: Builder) {
    /**
     * Configures SageMaker Automatic model tuning (AMT) to automatically find optimal parameters for the following fields:
     * + [ParameterRanges](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-ParameterRanges): The names and ranges of parameters that a hyperparameter tuning job can optimize.
     * + [ResourceLimits](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html): The maximum resources that can be used for a training job. These resources include the maximum number of training jobs, the maximum runtime of a tuning job, and the maximum number of training jobs to run at the same time.
     * + [TrainingJobEarlyStoppingType](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-TrainingJobEarlyStoppingType): A flag that specifies whether or not to use early stopping for training jobs launched by a hyperparameter tuning job.
     * + [RetryStrategy](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-RetryStrategy): The number of times to retry a training job.
     * + [Strategy](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html): Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training jobs that it launches.
     * + [ConvergenceDetected](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ConvergenceDetected.html): A flag to indicate that Automatic model tuning (AMT) has detected model convergence.
     */
    public val autotune: aws.sdk.kotlin.services.sagemaker.model.Autotune? = builder.autotune
    /**
     * The [HyperParameterTuningJobConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html) object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see [How Hyperparameter Tuning Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
     */
    public val hyperParameterTuningJobConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig? = builder.hyperParameterTuningJobConfig
    /**
     * The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.
     */
    public val hyperParameterTuningJobName: kotlin.String? = builder.hyperParameterTuningJobName
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     *
     * Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html) object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.
     */
    public val trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition? = builder.trainingJobDefinition
    /**
     * A list of the [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html) objects launched for this tuning job.
     */
    public val trainingJobDefinitions: List<HyperParameterTrainingJobDefinition>? = builder.trainingJobDefinitions
    /**
     * Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.
     *
     * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify `IDENTICAL_DATA_AND_ALGORITHM` as the `WarmStartType` value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.
     *
     * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.
     */
    public val warmStartConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig? = builder.warmStartConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateHyperParameterTuningJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHyperParameterTuningJobRequest(")
        append("autotune=$autotune,")
        append("hyperParameterTuningJobConfig=$hyperParameterTuningJobConfig,")
        append("hyperParameterTuningJobName=$hyperParameterTuningJobName,")
        append("tags=$tags,")
        append("trainingJobDefinition=$trainingJobDefinition,")
        append("trainingJobDefinitions=$trainingJobDefinitions,")
        append("warmStartConfig=$warmStartConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autotune?.hashCode() ?: 0
        result = 31 * result + (hyperParameterTuningJobConfig?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinition?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinitions?.hashCode() ?: 0)
        result = 31 * result + (warmStartConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHyperParameterTuningJobRequest

        if (autotune != other.autotune) return false
        if (hyperParameterTuningJobConfig != other.hyperParameterTuningJobConfig) return false
        if (hyperParameterTuningJobName != other.hyperParameterTuningJobName) return false
        if (tags != other.tags) return false
        if (trainingJobDefinition != other.trainingJobDefinition) return false
        if (trainingJobDefinitions != other.trainingJobDefinitions) return false
        if (warmStartConfig != other.warmStartConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateHyperParameterTuningJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configures SageMaker Automatic model tuning (AMT) to automatically find optimal parameters for the following fields:
         * + [ParameterRanges](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-ParameterRanges): The names and ranges of parameters that a hyperparameter tuning job can optimize.
         * + [ResourceLimits](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html): The maximum resources that can be used for a training job. These resources include the maximum number of training jobs, the maximum runtime of a tuning job, and the maximum number of training jobs to run at the same time.
         * + [TrainingJobEarlyStoppingType](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-TrainingJobEarlyStoppingType): A flag that specifies whether or not to use early stopping for training jobs launched by a hyperparameter tuning job.
         * + [RetryStrategy](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-RetryStrategy): The number of times to retry a training job.
         * + [Strategy](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html): Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training jobs that it launches.
         * + [ConvergenceDetected](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ConvergenceDetected.html): A flag to indicate that Automatic model tuning (AMT) has detected model convergence.
         */
        public var autotune: aws.sdk.kotlin.services.sagemaker.model.Autotune? = null
        /**
         * The [HyperParameterTuningJobConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html) object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see [How Hyperparameter Tuning Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
         */
        public var hyperParameterTuningJobConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig? = null
        /**
         * The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.
         */
        public var hyperParameterTuningJobName: kotlin.String? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         *
         * Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.
         */
        public var tags: List<Tag>? = null
        /**
         * The [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html) object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.
         */
        public var trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition? = null
        /**
         * A list of the [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html) objects launched for this tuning job.
         */
        public var trainingJobDefinitions: List<HyperParameterTrainingJobDefinition>? = null
        /**
         * Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.
         *
         * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify `IDENTICAL_DATA_AND_ALGORITHM` as the `WarmStartType` value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.
         *
         * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.
         */
        public var warmStartConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateHyperParameterTuningJobRequest) : this() {
            this.autotune = x.autotune
            this.hyperParameterTuningJobConfig = x.hyperParameterTuningJobConfig
            this.hyperParameterTuningJobName = x.hyperParameterTuningJobName
            this.tags = x.tags
            this.trainingJobDefinition = x.trainingJobDefinition
            this.trainingJobDefinitions = x.trainingJobDefinitions
            this.warmStartConfig = x.warmStartConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateHyperParameterTuningJobRequest = CreateHyperParameterTuningJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.Autotune] inside the given [block]
         */
        public fun autotune(block: aws.sdk.kotlin.services.sagemaker.model.Autotune.Builder.() -> kotlin.Unit) {
            this.autotune = aws.sdk.kotlin.services.sagemaker.model.Autotune.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig] inside the given [block]
         */
        public fun hyperParameterTuningJobConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig.Builder.() -> kotlin.Unit) {
            this.hyperParameterTuningJobConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition] inside the given [block]
         */
        public fun trainingJobDefinition(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition.Builder.() -> kotlin.Unit) {
            this.trainingJobDefinition = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig] inside the given [block]
         */
        public fun warmStartConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig.Builder.() -> kotlin.Unit) {
            this.warmStartConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig.invoke(block)
        }
    }
}
