// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateAutoMlJobV2Request private constructor(builder: Builder) {
    /**
     * An array of channel objects describing the input data and their location. Each channel is a named input source. Similar to the [InputDataConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig) attribute in the `CreateAutoMLJob` input parameters. The supported formats depend on the problem type:
     * + For tabular problem types: `S3Prefix`, `ManifestFile`.
     * + For image classification: `S3Prefix`, `ManifestFile`, `AugmentedManifestFile`.
     * + For text classification: `S3Prefix`.
     * + For time-series forecasting: `S3Prefix`.
     */
    public val autoMlJobInputDataConfig: List<AutoMlJobChannel>? = builder.autoMlJobInputDataConfig
    /**
     * Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
     */
    public val autoMlJobName: kotlin.String? = builder.autoMlJobName
    /**
     * Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective metric depends on the problem type. For the list of default values per problem type, see [AutoMLJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html).
     *
     * For tabular problem types, you must either provide both the `AutoMLJobObjective` and indicate the type of supervised learning problem in `AutoMLProblemTypeConfig` (`TabularJobConfig.ProblemType`), or none at all.
     */
    public val autoMlJobObjective: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective? = builder.autoMlJobObjective
    /**
     * Defines the configuration settings of one of the supported problem types.
     */
    public val autoMlProblemTypeConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlProblemTypeConfig? = builder.autoMlProblemTypeConfig
    /**
     * This structure specifies how to split the data into train and validation datasets.
     *
     * The validation and training datasets must contain the same headers. For jobs created by calling `CreateAutoMLJob`, the validation dataset must be less than 2 GB in size.
     *
     * This attribute must not be set for the time-series forecasting problem type, as Autopilot automatically splits the input dataset into training and validation sets.
     */
    public val dataSplitConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig? = builder.dataSplitConfig
    /**
     * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
     */
    public val modelDeployConfig: aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig? = builder.modelDeployConfig
    /**
     * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig? = builder.outputDataConfig
    /**
     * The ARN of the role that is used to access the data.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The security configuration for traffic encryption or Amazon VPC settings.
     */
    public val securityConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig? = builder.securityConfig
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, such as by purpose, owner, or environment. For more information, see [Tagging Amazon Web ServicesResources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). Tag keys must be unique per resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateAutoMlJobV2Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAutoMlJobV2Request(")
        append("autoMlJobInputDataConfig=$autoMlJobInputDataConfig,")
        append("autoMlJobName=$autoMlJobName,")
        append("autoMlJobObjective=$autoMlJobObjective,")
        append("autoMlProblemTypeConfig=$autoMlProblemTypeConfig,")
        append("dataSplitConfig=$dataSplitConfig,")
        append("modelDeployConfig=$modelDeployConfig,")
        append("outputDataConfig=$outputDataConfig,")
        append("roleArn=$roleArn,")
        append("securityConfig=$securityConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMlJobInputDataConfig?.hashCode() ?: 0
        result = 31 * result + (autoMlJobName?.hashCode() ?: 0)
        result = 31 * result + (autoMlJobObjective?.hashCode() ?: 0)
        result = 31 * result + (autoMlProblemTypeConfig?.hashCode() ?: 0)
        result = 31 * result + (dataSplitConfig?.hashCode() ?: 0)
        result = 31 * result + (modelDeployConfig?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (securityConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAutoMlJobV2Request

        if (autoMlJobInputDataConfig != other.autoMlJobInputDataConfig) return false
        if (autoMlJobName != other.autoMlJobName) return false
        if (autoMlJobObjective != other.autoMlJobObjective) return false
        if (autoMlProblemTypeConfig != other.autoMlProblemTypeConfig) return false
        if (dataSplitConfig != other.dataSplitConfig) return false
        if (modelDeployConfig != other.modelDeployConfig) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (roleArn != other.roleArn) return false
        if (securityConfig != other.securityConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateAutoMlJobV2Request = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of channel objects describing the input data and their location. Each channel is a named input source. Similar to the [InputDataConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig) attribute in the `CreateAutoMLJob` input parameters. The supported formats depend on the problem type:
         * + For tabular problem types: `S3Prefix`, `ManifestFile`.
         * + For image classification: `S3Prefix`, `ManifestFile`, `AugmentedManifestFile`.
         * + For text classification: `S3Prefix`.
         * + For time-series forecasting: `S3Prefix`.
         */
        public var autoMlJobInputDataConfig: List<AutoMlJobChannel>? = null
        /**
         * Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
         */
        public var autoMlJobName: kotlin.String? = null
        /**
         * Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective metric depends on the problem type. For the list of default values per problem type, see [AutoMLJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html).
         *
         * For tabular problem types, you must either provide both the `AutoMLJobObjective` and indicate the type of supervised learning problem in `AutoMLProblemTypeConfig` (`TabularJobConfig.ProblemType`), or none at all.
         */
        public var autoMlJobObjective: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective? = null
        /**
         * Defines the configuration settings of one of the supported problem types.
         */
        public var autoMlProblemTypeConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlProblemTypeConfig? = null
        /**
         * This structure specifies how to split the data into train and validation datasets.
         *
         * The validation and training datasets must contain the same headers. For jobs created by calling `CreateAutoMLJob`, the validation dataset must be less than 2 GB in size.
         *
         * This attribute must not be set for the time-series forecasting problem type, as Autopilot automatically splits the input dataset into training and validation sets.
         */
        public var dataSplitConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig? = null
        /**
         * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
         */
        public var modelDeployConfig: aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig? = null
        /**
         * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig? = null
        /**
         * The ARN of the role that is used to access the data.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The security configuration for traffic encryption or Amazon VPC settings.
         */
        public var securityConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, such as by purpose, owner, or environment. For more information, see [Tagging Amazon Web ServicesResources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). Tag keys must be unique per resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateAutoMlJobV2Request) : this() {
            this.autoMlJobInputDataConfig = x.autoMlJobInputDataConfig
            this.autoMlJobName = x.autoMlJobName
            this.autoMlJobObjective = x.autoMlJobObjective
            this.autoMlProblemTypeConfig = x.autoMlProblemTypeConfig
            this.dataSplitConfig = x.dataSplitConfig
            this.modelDeployConfig = x.modelDeployConfig
            this.outputDataConfig = x.outputDataConfig
            this.roleArn = x.roleArn
            this.securityConfig = x.securityConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateAutoMlJobV2Request = CreateAutoMlJobV2Request(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective] inside the given [block]
         */
        public fun autoMlJobObjective(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective.Builder.() -> kotlin.Unit) {
            this.autoMlJobObjective = aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig] inside the given [block]
         */
        public fun dataSplitConfig(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig.Builder.() -> kotlin.Unit) {
            this.dataSplitConfig = aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig] inside the given [block]
         */
        public fun modelDeployConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig.Builder.() -> kotlin.Unit) {
            this.modelDeployConfig = aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig] inside the given [block]
         */
        public fun securityConfig(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig.Builder.() -> kotlin.Unit) {
            this.securityConfig = aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig.invoke(block)
        }
    }
}
