// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateAutoMlJobRequest private constructor(builder: Builder) {
    /**
     * A collection of settings used to configure an AutoML job.
     */
    public val autoMlJobConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig? = builder.autoMlJobConfig
    /**
     * Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
     */
    public val autoMlJobName: kotlin.String? = builder.autoMlJobName
    /**
     * Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective metric depends on the problem type. See [AutoMLJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html) for the default values.
     */
    public val autoMlJobObjective: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective? = builder.autoMlJobObjective
    /**
     * Generates possible candidates without training the models. A candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.
     */
    public val generateCandidateDefinitionsOnly: kotlin.Boolean = builder.generateCandidateDefinitionsOnly
    /**
     * An array of channel objects that describes the input data and its location. Each channel is a named input source. Similar to `InputDataConfig` supported by [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html). Format(s) supported: CSV, Parquet. A minimum of 500 rows is required for the training dataset. There is not a minimum number of rows required for the validation dataset.
     */
    public val inputDataConfig: List<AutoMlChannel>? = builder.inputDataConfig
    /**
     * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
     */
    public val modelDeployConfig: aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig? = builder.modelDeployConfig
    /**
     * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job. Format(s) supported: CSV.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig? = builder.outputDataConfig
    /**
     * Defines the type of supervised learning problem available for the candidates. For more information, see [ Amazon SageMaker Autopilot problem types](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types).
     */
    public val problemType: aws.sdk.kotlin.services.sagemaker.model.ProblemType? = builder.problemType
    /**
     * The ARN of the role that is used to access the data.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web ServicesResources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). Tag keys must be unique per resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateAutoMlJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAutoMlJobRequest(")
        append("autoMlJobConfig=$autoMlJobConfig,")
        append("autoMlJobName=$autoMlJobName,")
        append("autoMlJobObjective=$autoMlJobObjective,")
        append("generateCandidateDefinitionsOnly=$generateCandidateDefinitionsOnly,")
        append("inputDataConfig=$inputDataConfig,")
        append("modelDeployConfig=$modelDeployConfig,")
        append("outputDataConfig=$outputDataConfig,")
        append("problemType=$problemType,")
        append("roleArn=$roleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMlJobConfig?.hashCode() ?: 0
        result = 31 * result + (autoMlJobName?.hashCode() ?: 0)
        result = 31 * result + (autoMlJobObjective?.hashCode() ?: 0)
        result = 31 * result + (generateCandidateDefinitionsOnly.hashCode())
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (modelDeployConfig?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (problemType?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAutoMlJobRequest

        if (autoMlJobConfig != other.autoMlJobConfig) return false
        if (autoMlJobName != other.autoMlJobName) return false
        if (autoMlJobObjective != other.autoMlJobObjective) return false
        if (generateCandidateDefinitionsOnly != other.generateCandidateDefinitionsOnly) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (modelDeployConfig != other.modelDeployConfig) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (problemType != other.problemType) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateAutoMlJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A collection of settings used to configure an AutoML job.
         */
        public var autoMlJobConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig? = null
        /**
         * Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
         */
        public var autoMlJobName: kotlin.String? = null
        /**
         * Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective metric depends on the problem type. See [AutoMLJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html) for the default values.
         */
        public var autoMlJobObjective: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective? = null
        /**
         * Generates possible candidates without training the models. A candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.
         */
        public var generateCandidateDefinitionsOnly: kotlin.Boolean = false
        /**
         * An array of channel objects that describes the input data and its location. Each channel is a named input source. Similar to `InputDataConfig` supported by [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html). Format(s) supported: CSV, Parquet. A minimum of 500 rows is required for the training dataset. There is not a minimum number of rows required for the validation dataset.
         */
        public var inputDataConfig: List<AutoMlChannel>? = null
        /**
         * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
         */
        public var modelDeployConfig: aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig? = null
        /**
         * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job. Format(s) supported: CSV.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig? = null
        /**
         * Defines the type of supervised learning problem available for the candidates. For more information, see [ Amazon SageMaker Autopilot problem types](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types).
         */
        public var problemType: aws.sdk.kotlin.services.sagemaker.model.ProblemType? = null
        /**
         * The ARN of the role that is used to access the data.
         */
        public var roleArn: kotlin.String? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web ServicesResources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). Tag keys must be unique per resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateAutoMlJobRequest) : this() {
            this.autoMlJobConfig = x.autoMlJobConfig
            this.autoMlJobName = x.autoMlJobName
            this.autoMlJobObjective = x.autoMlJobObjective
            this.generateCandidateDefinitionsOnly = x.generateCandidateDefinitionsOnly
            this.inputDataConfig = x.inputDataConfig
            this.modelDeployConfig = x.modelDeployConfig
            this.outputDataConfig = x.outputDataConfig
            this.problemType = x.problemType
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateAutoMlJobRequest = CreateAutoMlJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig] inside the given [block]
         */
        public fun autoMlJobConfig(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig.Builder.() -> kotlin.Unit) {
            this.autoMlJobConfig = aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective] inside the given [block]
         */
        public fun autoMlJobObjective(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective.Builder.() -> kotlin.Unit) {
            this.autoMlJobObjective = aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig] inside the given [block]
         */
        public fun modelDeployConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig.Builder.() -> kotlin.Unit) {
            this.modelDeployConfig = aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig.invoke(block)
        }
    }
}
