// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies a metric to minimize or maximize as the objective of a job.
 */
public class AutoMlJobObjective private constructor(builder: Builder) {
    /**
     * The name of the objective metric used to measure the predictive quality of a machine learning system. During training, the model's parameters are updated iteratively to optimize its performance based on the feedback provided by the objective metric when evaluating the model on the validation dataset.
     *
     * For the list of all available metrics supported by Autopilot, see [Autopilot metrics](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html#autopilot-metrics).
     *
     * If you do not specify a metric explicitly, the default behavior is to automatically use:
     * + For tabular problem types:
     *    + Regression: `MSE`.
     *    + Binary classification: `F1`.
     *    + Multiclass classification: `Accuracy`.
     * + For image or text classification problem types: `Accuracy`
     * + For time-series forecasting problem types: `AverageWeightedQuantileLoss`
     */
    public val metricName: aws.sdk.kotlin.services.sagemaker.model.AutoMlMetricEnum? = builder.metricName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlJobObjective(")
        append("metricName=$metricName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricName?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlJobObjective

        if (metricName != other.metricName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the objective metric used to measure the predictive quality of a machine learning system. During training, the model's parameters are updated iteratively to optimize its performance based on the feedback provided by the objective metric when evaluating the model on the validation dataset.
         *
         * For the list of all available metrics supported by Autopilot, see [Autopilot metrics](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html#autopilot-metrics).
         *
         * If you do not specify a metric explicitly, the default behavior is to automatically use:
         * + For tabular problem types:
         *    + Regression: `MSE`.
         *    + Binary classification: `F1`.
         *    + Multiclass classification: `Accuracy`.
         * + For image or text classification problem types: `Accuracy`
         * + For time-series forecasting problem types: `AverageWeightedQuantileLoss`
         */
        public var metricName: aws.sdk.kotlin.services.sagemaker.model.AutoMlMetricEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective) : this() {
            this.metricName = x.metricName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective = AutoMlJobObjective(this)
    }
}
