// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A collection of settings used for an AutoML job.
 */
public class AutoMlJobConfig private constructor(builder: Builder) {
    /**
     * The configuration for generating a candidate for an AutoML job (optional).
     */
    public val candidateGenerationConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig? = builder.candidateGenerationConfig
    /**
     * How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
     */
    public val completionCriteria: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria? = builder.completionCriteria
    /**
     * The configuration for splitting the input training dataset.
     *
     * Type: AutoMLDataSplitConfig
     */
    public val dataSplitConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig? = builder.dataSplitConfig
    /**
     * The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot choose for you based on the dataset size by selecting `AUTO`. In `AUTO` mode, Autopilot chooses `ENSEMBLING` for datasets smaller than 100 MB, and `HYPERPARAMETER_TUNING` for larger ones.
     *
     * The `ENSEMBLING` mode uses a multi-stack ensemble model to predict classification and regression tasks directly from your dataset. This machine learning mode combines several base models to produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions from contributing members. A multi-stack ensemble model can provide better performance over a single model by combining the predictive capabilities of multiple models. See [Autopilot algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) for a list of algorithms supported by `ENSEMBLING` mode.
     *
     * The `HYPERPARAMETER_TUNING` (HPO) mode uses the best hyperparameters to train the best version of a model. HPO automatically selects an algorithm for the type of problem you want to solve. Then HPO finds the best hyperparameters according to your objective metric. See [Autopilot algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) for a list of algorithms supported by `HYPERPARAMETER_TUNING` mode.
     */
    public val mode: aws.sdk.kotlin.services.sagemaker.model.AutoMlMode? = builder.mode
    /**
     * The security configuration for traffic encryption or Amazon VPC settings.
     */
    public val securityConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig? = builder.securityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlJobConfig(")
        append("candidateGenerationConfig=$candidateGenerationConfig,")
        append("completionCriteria=$completionCriteria,")
        append("dataSplitConfig=$dataSplitConfig,")
        append("mode=$mode,")
        append("securityConfig=$securityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = candidateGenerationConfig?.hashCode() ?: 0
        result = 31 * result + (completionCriteria?.hashCode() ?: 0)
        result = 31 * result + (dataSplitConfig?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (securityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlJobConfig

        if (candidateGenerationConfig != other.candidateGenerationConfig) return false
        if (completionCriteria != other.completionCriteria) return false
        if (dataSplitConfig != other.dataSplitConfig) return false
        if (mode != other.mode) return false
        if (securityConfig != other.securityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration for generating a candidate for an AutoML job (optional).
         */
        public var candidateGenerationConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig? = null
        /**
         * How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
         */
        public var completionCriteria: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria? = null
        /**
         * The configuration for splitting the input training dataset.
         *
         * Type: AutoMLDataSplitConfig
         */
        public var dataSplitConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig? = null
        /**
         * The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot choose for you based on the dataset size by selecting `AUTO`. In `AUTO` mode, Autopilot chooses `ENSEMBLING` for datasets smaller than 100 MB, and `HYPERPARAMETER_TUNING` for larger ones.
         *
         * The `ENSEMBLING` mode uses a multi-stack ensemble model to predict classification and regression tasks directly from your dataset. This machine learning mode combines several base models to produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions from contributing members. A multi-stack ensemble model can provide better performance over a single model by combining the predictive capabilities of multiple models. See [Autopilot algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) for a list of algorithms supported by `ENSEMBLING` mode.
         *
         * The `HYPERPARAMETER_TUNING` (HPO) mode uses the best hyperparameters to train the best version of a model. HPO automatically selects an algorithm for the type of problem you want to solve. Then HPO finds the best hyperparameters according to your objective metric. See [Autopilot algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) for a list of algorithms supported by `HYPERPARAMETER_TUNING` mode.
         */
        public var mode: aws.sdk.kotlin.services.sagemaker.model.AutoMlMode? = null
        /**
         * The security configuration for traffic encryption or Amazon VPC settings.
         */
        public var securityConfig: aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig) : this() {
            this.candidateGenerationConfig = x.candidateGenerationConfig
            this.completionCriteria = x.completionCriteria
            this.dataSplitConfig = x.dataSplitConfig
            this.mode = x.mode
            this.securityConfig = x.securityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobConfig = AutoMlJobConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig] inside the given [block]
         */
        public fun candidateGenerationConfig(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig.Builder.() -> kotlin.Unit) {
            this.candidateGenerationConfig = aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria] inside the given [block]
         */
        public fun completionCriteria(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria.Builder.() -> kotlin.Unit) {
            this.completionCriteria = aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig] inside the given [block]
         */
        public fun dataSplitConfig(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig.Builder.() -> kotlin.Unit) {
            this.dataSplitConfig = aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig] inside the given [block]
         */
        public fun securityConfig(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig.Builder.() -> kotlin.Unit) {
            this.securityConfig = aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig.invoke(block)
        }
    }
}
