// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A channel is a named input source that training algorithms can consume. This channel is used for AutoML jobs V2 (jobs created by calling [CreateAutoMLJobV2](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html)).
 */
public class AutoMlJobChannel private constructor(builder: Builder) {
    /**
     * The type of channel. Defines whether the data are used for training or validation. The default value is `training`. Channels for `training` and `validation` must share the same `ContentType`
     *
     * The type of channel defaults to `training` for the time-series forecasting problem type.
     */
    public val channelType: aws.sdk.kotlin.services.sagemaker.model.AutoMlChannelType? = builder.channelType
    /**
     * The allowed compression types depend on the input format and problem type. We allow the compression type `Gzip` for `S3Prefix` inputs on tabular data only. For all other inputs, the compression type should be `None`. If no compression type is provided, we default to `None`.
     */
    public val compressionType: aws.sdk.kotlin.services.sagemaker.model.CompressionType? = builder.compressionType
    /**
     * The content type of the data from the input source. The following are the allowed content types for different problems:
     * + For tabular problem types: `text/csv;header=present` or `x-application/vnd.amazon+parquet`. The default value is `text/csv;header=present`.
     * + For image classification: `image/png`, `image/jpeg`, or `image&#47;*`. The default value is `image&#47;*`.
     * + For text classification: `text/csv;header=present` or `x-application/vnd.amazon+parquet`. The default value is `text/csv;header=present`.
     * + For time-series forecasting: `text/csv;header=present` or `x-application/vnd.amazon+parquet`. The default value is `text/csv;header=present`.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The data source for an AutoML channel (Required).
     */
    public val dataSource: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource? = builder.dataSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobChannel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlJobChannel(")
        append("channelType=$channelType,")
        append("compressionType=$compressionType,")
        append("contentType=$contentType,")
        append("dataSource=$dataSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelType?.hashCode() ?: 0
        result = 31 * result + (compressionType?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlJobChannel

        if (channelType != other.channelType) return false
        if (compressionType != other.compressionType) return false
        if (contentType != other.contentType) return false
        if (dataSource != other.dataSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobChannel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of channel. Defines whether the data are used for training or validation. The default value is `training`. Channels for `training` and `validation` must share the same `ContentType`
         *
         * The type of channel defaults to `training` for the time-series forecasting problem type.
         */
        public var channelType: aws.sdk.kotlin.services.sagemaker.model.AutoMlChannelType? = null
        /**
         * The allowed compression types depend on the input format and problem type. We allow the compression type `Gzip` for `S3Prefix` inputs on tabular data only. For all other inputs, the compression type should be `None`. If no compression type is provided, we default to `None`.
         */
        public var compressionType: aws.sdk.kotlin.services.sagemaker.model.CompressionType? = null
        /**
         * The content type of the data from the input source. The following are the allowed content types for different problems:
         * + For tabular problem types: `text/csv;header=present` or `x-application/vnd.amazon+parquet`. The default value is `text/csv;header=present`.
         * + For image classification: `image/png`, `image/jpeg`, or `image&#47;*`. The default value is `image&#47;*`.
         * + For text classification: `text/csv;header=present` or `x-application/vnd.amazon+parquet`. The default value is `text/csv;header=present`.
         * + For time-series forecasting: `text/csv;header=present` or `x-application/vnd.amazon+parquet`. The default value is `text/csv;header=present`.
         */
        public var contentType: kotlin.String? = null
        /**
         * The data source for an AutoML channel (Required).
         */
        public var dataSource: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobChannel) : this() {
            this.channelType = x.channelType
            this.compressionType = x.compressionType
            this.contentType = x.contentType
            this.dataSource = x.dataSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobChannel = AutoMlJobChannel(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource.invoke(block)
        }
    }
}
