// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * The encryption configuration for a vector bucket. By default, if you don't specify, all new vectors in Amazon S3 vector buckets use server-side encryption with Amazon S3 managed keys (SSE-S3), specifically `AES256`.
 */
public class EncryptionConfiguration private constructor(builder: Builder) {
    /**
     * Amazon Web Services Key Management Service (KMS) customer managed key ID to use for the encryption configuration. This parameter is allowed if and only if `sseType` is set to `aws:kms`.
     *
     * To specify the KMS key, you must use the format of the KMS key Amazon Resource Name (ARN).
     *
     * For example, specify Key ARN in the following format: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The server-side encryption type to use for the encryption configuration of the vector bucket. By default, if you don't specify, all new vectors in Amazon S3 vector buckets use server-side encryption with Amazon S3 managed keys (SSE-S3), specifically `AES256`.
     */
    public val sseType: aws.sdk.kotlin.services.s3vectors.model.SseType = builder.sseType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3vectors.model.EncryptionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfiguration(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("sseType=$sseType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (sseType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfiguration

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (sseType != other.sseType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3vectors.model.EncryptionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Web Services Key Management Service (KMS) customer managed key ID to use for the encryption configuration. This parameter is allowed if and only if `sseType` is set to `aws:kms`.
         *
         * To specify the KMS key, you must use the format of the KMS key Amazon Resource Name (ARN).
         *
         * For example, specify Key ARN in the following format: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The server-side encryption type to use for the encryption configuration of the vector bucket. By default, if you don't specify, all new vectors in Amazon S3 vector buckets use server-side encryption with Amazon S3 managed keys (SSE-S3), specifically `AES256`.
         */
        public var sseType: aws.sdk.kotlin.services.s3vectors.model.SseType = aws.sdk.kotlin.services.s3vectors.model.SseType.fromValue("AES256")

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3vectors.model.EncryptionConfiguration) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.sseType = x.sseType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3vectors.model.EncryptionConfiguration = EncryptionConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
