// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Summary information about a vector bucket.
 */
public class VectorBucketSummary private constructor(builder: Builder) {
    /**
     * Date and time when the vector bucket was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The Amazon Resource Name (ARN) of the vector bucket.
     */
    public val vectorBucketArn: kotlin.String = requireNotNull(builder.vectorBucketArn) { "A non-null value must be provided for vectorBucketArn" }
    /**
     * The name of the vector bucket.
     */
    public val vectorBucketName: kotlin.String = requireNotNull(builder.vectorBucketName) { "A non-null value must be provided for vectorBucketName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3vectors.model.VectorBucketSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VectorBucketSummary(")
        append("creationTime=$creationTime,")
        append("vectorBucketArn=$vectorBucketArn,")
        append("vectorBucketName=$vectorBucketName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (vectorBucketArn.hashCode())
        result = 31 * result + (vectorBucketName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VectorBucketSummary

        if (creationTime != other.creationTime) return false
        if (vectorBucketArn != other.vectorBucketArn) return false
        if (vectorBucketName != other.vectorBucketName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3vectors.model.VectorBucketSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Date and time when the vector bucket was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the vector bucket.
         */
        public var vectorBucketArn: kotlin.String? = null
        /**
         * The name of the vector bucket.
         */
        public var vectorBucketName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3vectors.model.VectorBucketSummary) : this() {
            this.creationTime = x.creationTime
            this.vectorBucketArn = x.vectorBucketArn
            this.vectorBucketName = x.vectorBucketName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3vectors.model.VectorBucketSummary = VectorBucketSummary(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (vectorBucketArn == null) vectorBucketArn = ""
            if (vectorBucketName == null) vectorBucketName = ""
            return this
        }
    }
}
