// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Summary information about a vector index.
 */
public class IndexSummary private constructor(builder: Builder) {
    /**
     * Date and time when the vector index was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The Amazon Resource Name (ARN) of the vector index.
     */
    public val indexArn: kotlin.String = requireNotNull(builder.indexArn) { "A non-null value must be provided for indexArn" }
    /**
     * The name of the vector index.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The name of the vector bucket that contains the vector index.
     */
    public val vectorBucketName: kotlin.String = requireNotNull(builder.vectorBucketName) { "A non-null value must be provided for vectorBucketName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3vectors.model.IndexSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IndexSummary(")
        append("creationTime=$creationTime,")
        append("indexArn=$indexArn,")
        append("indexName=$indexName,")
        append("vectorBucketName=$vectorBucketName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (indexArn.hashCode())
        result = 31 * result + (indexName.hashCode())
        result = 31 * result + (vectorBucketName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IndexSummary

        if (creationTime != other.creationTime) return false
        if (indexArn != other.indexArn) return false
        if (indexName != other.indexName) return false
        if (vectorBucketName != other.vectorBucketName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3vectors.model.IndexSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Date and time when the vector index was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the vector index.
         */
        public var indexArn: kotlin.String? = null
        /**
         * The name of the vector index.
         */
        public var indexName: kotlin.String? = null
        /**
         * The name of the vector bucket that contains the vector index.
         */
        public var vectorBucketName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3vectors.model.IndexSummary) : this() {
            this.creationTime = x.creationTime
            this.indexArn = x.indexArn
            this.indexName = x.indexName
            this.vectorBucketName = x.vectorBucketName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3vectors.model.IndexSummary = IndexSummary(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (indexArn == null) indexArn = ""
            if (indexName == null) indexName = ""
            if (vectorBucketName == null) vectorBucketName = ""
            return this
        }
    }
}
