// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.endpoints

import aws.sdk.kotlin.services.s3vectors.endpoints.internal.partition
import aws.smithy.kotlin.runtime.businessmetrics.ServiceEndpointOverride
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultS3VectorsEndpointProvider: S3VectorsEndpointProvider {
    public override suspend fun resolveEndpoint(params: S3VectorsEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
                attributes = attributesOf {
                    ServiceEndpointOverride to true
                },
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true
                    ) {
                        return Endpoint(
                            Url.parse("https://s3vectors-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    return Endpoint(
                        Url.parse("https://s3vectors.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
