// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.content.Document

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * The attributes of a vector to add to a vector index.
 */
public class PutInputVector private constructor(builder: Builder) {
    /**
     * The vector data of the vector.
     *
     * Vector dimensions must match the dimension count that's configured for the vector index.
     * + For the `cosine` distance metric, zero vectors (vectors containing all zeros) aren't allowed.
     * + For both `cosine` and `euclidean` distance metrics, vector data must contain only valid floating-point values. Invalid values such as NaN (Not a Number) or Infinity aren't allowed.
     */
    public val data: aws.sdk.kotlin.services.s3vectors.model.VectorData? = builder.data
    /**
     * The name of the vector. The key uniquely identifies the vector in a vector index.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * Metadata about the vector. All metadata entries undergo validation to ensure they meet the format requirements for size and data types.
     */
    public val metadata: aws.smithy.kotlin.runtime.content.Document? = builder.metadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3vectors.model.PutInputVector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutInputVector(")
        append("data=$data,")
        append("key=$key,")
        append("metadata=$metadata")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = data?.hashCode() ?: 0
        result = 31 * result + (key.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutInputVector

        if (data != other.data) return false
        if (key != other.key) return false
        if (metadata != other.metadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3vectors.model.PutInputVector = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The vector data of the vector.
         *
         * Vector dimensions must match the dimension count that's configured for the vector index.
         * + For the `cosine` distance metric, zero vectors (vectors containing all zeros) aren't allowed.
         * + For both `cosine` and `euclidean` distance metrics, vector data must contain only valid floating-point values. Invalid values such as NaN (Not a Number) or Infinity aren't allowed.
         */
        public var data: aws.sdk.kotlin.services.s3vectors.model.VectorData? = null
        /**
         * The name of the vector. The key uniquely identifies the vector in a vector index.
         */
        public var key: kotlin.String? = null
        /**
         * Metadata about the vector. All metadata entries undergo validation to ensure they meet the format requirements for size and data types.
         */
        public var metadata: aws.smithy.kotlin.runtime.content.Document? = aws.smithy.kotlin.runtime.content.Document(mapOf())

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3vectors.model.PutInputVector) : this() {
            this.data = x.data
            this.key = x.key
            this.metadata = x.metadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3vectors.model.PutInputVector = PutInputVector(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            return this
        }
    }
}
