// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.s3vectors.auth.DefaultS3VectorsAuthSchemeProvider
import aws.sdk.kotlin.services.s3vectors.auth.S3VectorsAuthSchemeProvider
import aws.sdk.kotlin.services.s3vectors.endpoints.DefaultS3VectorsEndpointProvider
import aws.sdk.kotlin.services.s3vectors.endpoints.S3VectorsEndpointParameters
import aws.sdk.kotlin.services.s3vectors.endpoints.S3VectorsEndpointProvider
import aws.sdk.kotlin.services.s3vectors.model.CreateIndexRequest
import aws.sdk.kotlin.services.s3vectors.model.CreateIndexResponse
import aws.sdk.kotlin.services.s3vectors.model.CreateVectorBucketRequest
import aws.sdk.kotlin.services.s3vectors.model.CreateVectorBucketResponse
import aws.sdk.kotlin.services.s3vectors.model.DeleteIndexRequest
import aws.sdk.kotlin.services.s3vectors.model.DeleteIndexResponse
import aws.sdk.kotlin.services.s3vectors.model.DeleteVectorBucketPolicyRequest
import aws.sdk.kotlin.services.s3vectors.model.DeleteVectorBucketPolicyResponse
import aws.sdk.kotlin.services.s3vectors.model.DeleteVectorBucketRequest
import aws.sdk.kotlin.services.s3vectors.model.DeleteVectorBucketResponse
import aws.sdk.kotlin.services.s3vectors.model.DeleteVectorsRequest
import aws.sdk.kotlin.services.s3vectors.model.DeleteVectorsResponse
import aws.sdk.kotlin.services.s3vectors.model.GetIndexRequest
import aws.sdk.kotlin.services.s3vectors.model.GetIndexResponse
import aws.sdk.kotlin.services.s3vectors.model.GetVectorBucketPolicyRequest
import aws.sdk.kotlin.services.s3vectors.model.GetVectorBucketPolicyResponse
import aws.sdk.kotlin.services.s3vectors.model.GetVectorBucketRequest
import aws.sdk.kotlin.services.s3vectors.model.GetVectorBucketResponse
import aws.sdk.kotlin.services.s3vectors.model.GetVectorsRequest
import aws.sdk.kotlin.services.s3vectors.model.GetVectorsResponse
import aws.sdk.kotlin.services.s3vectors.model.ListIndexesRequest
import aws.sdk.kotlin.services.s3vectors.model.ListIndexesResponse
import aws.sdk.kotlin.services.s3vectors.model.ListVectorBucketsRequest
import aws.sdk.kotlin.services.s3vectors.model.ListVectorBucketsResponse
import aws.sdk.kotlin.services.s3vectors.model.ListVectorsRequest
import aws.sdk.kotlin.services.s3vectors.model.ListVectorsResponse
import aws.sdk.kotlin.services.s3vectors.model.PutVectorBucketPolicyRequest
import aws.sdk.kotlin.services.s3vectors.model.PutVectorBucketPolicyResponse
import aws.sdk.kotlin.services.s3vectors.model.PutVectorsRequest
import aws.sdk.kotlin.services.s3vectors.model.PutVectorsResponse
import aws.sdk.kotlin.services.s3vectors.model.QueryVectorsRequest
import aws.sdk.kotlin.services.s3vectors.model.QueryVectorsResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "S3Vectors"
public const val SdkVersion: String = "1.5.30"
public const val ServiceApiVersion: String = "2025-07-15"

/**
 * Amazon S3 vector buckets are a bucket type to store and search vectors with sub-second search times. They are designed to provide dedicated API operations for you to interact with vectors to do similarity search. Within a vector bucket, you use a vector index to organize and logically group your vector data. When you make a write or read request, you direct it to a single vector index. You store your vector data as vectors. A vector contains a key (a name that you assign), a multi-dimensional vector, and, optionally, metadata that describes a vector. The key uniquely identifies the vector in a vector index.
 */
public interface S3VectorsClient : SdkClient {
    /**
     * S3VectorsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, S3VectorsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "S3Vectors",
                "S3VECTORS",
                "s3vectors",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, S3VectorsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): S3VectorsClient = DefaultS3VectorsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: S3VectorsEndpointProvider = builder.endpointProvider ?: DefaultS3VectorsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: S3VectorsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultS3VectorsAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "S3Vectors"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: S3VectorsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: S3VectorsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Creates a vector index within a vector bucket. To specify the vector bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:CreateIndex` permission to use this operation.
     */
    public suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Creates a vector bucket in the Amazon Web Services Region that you want your bucket to be in.
     *
     * ## Permissions
     * You must have the `s3vectors:CreateVectorBucket` permission to use this operation.
     */
    public suspend fun createVectorBucket(input: CreateVectorBucketRequest): CreateVectorBucketResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Deletes a vector index. To specify the vector index, you can either use both the vector bucket name and vector index name, or use the vector index Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:DeleteIndex` permission to use this operation.
     */
    public suspend fun deleteIndex(input: DeleteIndexRequest = DeleteIndexRequest { }): DeleteIndexResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Deletes a vector bucket. All vector indexes in the vector bucket must be deleted before the vector bucket can be deleted. To perform this operation, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:DeleteVectorBucket` permission to use this operation.
     */
    public suspend fun deleteVectorBucket(input: DeleteVectorBucketRequest = DeleteVectorBucketRequest { }): DeleteVectorBucketResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Deletes a vector bucket policy. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:DeleteVectorBucketPolicy` permission to use this operation.
     */
    public suspend fun deleteVectorBucketPolicy(input: DeleteVectorBucketPolicyRequest = DeleteVectorBucketPolicyRequest { }): DeleteVectorBucketPolicyResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Deletes one or more vectors in a vector index. To specify the vector index, you can either use both the vector bucket name and vector index name, or use the vector index Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:DeleteVectors` permission to use this operation.
     */
    public suspend fun deleteVectors(input: DeleteVectorsRequest): DeleteVectorsResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Returns vector index attributes. To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:GetIndex` permission to use this operation.
     */
    public suspend fun getIndex(input: GetIndexRequest = GetIndexRequest { }): GetIndexResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Returns vector bucket attributes. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:GetVectorBucket` permission to use this operation.
     */
    public suspend fun getVectorBucket(input: GetVectorBucketRequest = GetVectorBucketRequest { }): GetVectorBucketResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Gets details about a vector bucket policy. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:GetVectorBucketPolicy` permission to use this operation.
     */
    public suspend fun getVectorBucketPolicy(input: GetVectorBucketPolicyRequest = GetVectorBucketPolicyRequest { }): GetVectorBucketPolicyResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Returns vector attributes. To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:GetVectors` permission to use this operation.
     */
    public suspend fun getVectors(input: GetVectorsRequest): GetVectorsResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Returns a list of all the vector indexes within the specified vector bucket. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:ListIndexes` permission to use this operation.
     */
    public suspend fun listIndexes(input: ListIndexesRequest = ListIndexesRequest { }): ListIndexesResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Returns a list of all the vector buckets that are owned by the authenticated sender of the request.
     *
     * ## Permissions
     * You must have the `s3vectors:ListVectorBuckets` permission to use this operation.
     */
    public suspend fun listVectorBuckets(input: ListVectorBucketsRequest = ListVectorBucketsRequest { }): ListVectorBucketsResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * List vectors in the specified vector index. To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     *
     * `ListVectors` operations proceed sequentially; however, for faster performance on a large number of vectors in a vector index, applications can request a parallel `ListVectors` operation by providing the `segmentCount` and `segmentIndex` parameters.
     *
     * ## Permissions
     * You must have the `s3vectors:ListVectors` permission to use this operation. Additional permissions are required based on the request parameters you specify:
     * + With only `s3vectors:ListVectors` permission, you can list vector keys when `returnData` and `returnMetadata` are both set to false or not specified..
     * + If you set `returnData` or `returnMetadata` to true, you must have both `s3vectors:ListVectors` and `s3vectors:GetVectors` permissions. The request fails with a `403 Forbidden` error if you request vector data or metadata without the `s3vectors:GetVectors` permission.
     */
    public suspend fun listVectors(input: ListVectorsRequest = ListVectorsRequest { }): ListVectorsResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Creates a bucket policy for a vector bucket. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:PutVectorBucketPolicy` permission to use this operation.
     */
    public suspend fun putVectorBucketPolicy(input: PutVectorBucketPolicyRequest): PutVectorBucketPolicyResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Adds one or more vectors to a vector index. To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     *
     * For more information about limits, see [Limitations and restrictions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html) in the *Amazon S3 User Guide*.
     *
     * When inserting vector data into your vector index, you must provide the vector data as `float32` (32-bit floating point) values. If you pass higher-precision values to an Amazon Web Services SDK, S3 Vectors converts the values to 32-bit floating point before storing them, and `GetVectors`, `ListVectors`, and `QueryVectors` operations return the float32 values. Different Amazon Web Services SDKs may have different default numeric types, so ensure your vectors are properly formatted as `float32` values regardless of which SDK you're using. For example, in Python, use `numpy.float32` or explicitly cast your values.
     *
     * ## Permissions
     * You must have the `s3vectors:PutVectors` permission to use this operation.
     */
    public suspend fun putVectors(input: PutVectorsRequest): PutVectorsResponse

    /**
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     *
     * Performs an approximate nearest neighbor search query in a vector index using a query vector. By default, it returns the keys of approximate nearest neighbors. You can optionally include the computed distance (between the query vector and each vector in the response), the vector data, and metadata of each vector in the response.
     *
     * To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     *
     * ## Permissions
     * You must have the `s3vectors:QueryVectors` permission to use this operation. Additional permissions are required based on the request parameters you specify:
     * + With only `s3vectors:QueryVectors` permission, you can retrieve vector keys of approximate nearest neighbors and computed distances between these vectors. This permission is sufficient only when you don't set any metadata filters and don't request vector data or metadata (by keeping the `returnMetadata` parameter set to `false` or not specified).
     * + If you specify a metadata filter or set `returnMetadata` to true, you must have both `s3vectors:QueryVectors` and `s3vectors:GetVectors` permissions. The request fails with a `403 Forbidden error` if you request metadata filtering, vector data, or metadata without the `s3vectors:GetVectors` permission.
     */
    public suspend fun queryVectors(input: QueryVectorsRequest): QueryVectorsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun S3VectorsClient.withConfig(block: S3VectorsClient.Config.Builder.() -> Unit): S3VectorsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultS3VectorsClient(newConfig)
}

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Creates a vector index within a vector bucket. To specify the vector bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:CreateIndex` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.createIndex(crossinline block: CreateIndexRequest.Builder.() -> Unit): CreateIndexResponse = createIndex(CreateIndexRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Creates a vector bucket in the Amazon Web Services Region that you want your bucket to be in.
 *
 * ## Permissions
 * You must have the `s3vectors:CreateVectorBucket` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.createVectorBucket(crossinline block: CreateVectorBucketRequest.Builder.() -> Unit): CreateVectorBucketResponse = createVectorBucket(CreateVectorBucketRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Deletes a vector index. To specify the vector index, you can either use both the vector bucket name and vector index name, or use the vector index Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:DeleteIndex` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.deleteIndex(crossinline block: DeleteIndexRequest.Builder.() -> Unit): DeleteIndexResponse = deleteIndex(DeleteIndexRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Deletes a vector bucket. All vector indexes in the vector bucket must be deleted before the vector bucket can be deleted. To perform this operation, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:DeleteVectorBucket` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.deleteVectorBucket(crossinline block: DeleteVectorBucketRequest.Builder.() -> Unit): DeleteVectorBucketResponse = deleteVectorBucket(DeleteVectorBucketRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Deletes a vector bucket policy. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:DeleteVectorBucketPolicy` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.deleteVectorBucketPolicy(crossinline block: DeleteVectorBucketPolicyRequest.Builder.() -> Unit): DeleteVectorBucketPolicyResponse = deleteVectorBucketPolicy(DeleteVectorBucketPolicyRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Deletes one or more vectors in a vector index. To specify the vector index, you can either use both the vector bucket name and vector index name, or use the vector index Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:DeleteVectors` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.deleteVectors(crossinline block: DeleteVectorsRequest.Builder.() -> Unit): DeleteVectorsResponse = deleteVectors(DeleteVectorsRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Returns vector index attributes. To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:GetIndex` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.getIndex(crossinline block: GetIndexRequest.Builder.() -> Unit): GetIndexResponse = getIndex(GetIndexRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Returns vector bucket attributes. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:GetVectorBucket` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.getVectorBucket(crossinline block: GetVectorBucketRequest.Builder.() -> Unit): GetVectorBucketResponse = getVectorBucket(GetVectorBucketRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Gets details about a vector bucket policy. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:GetVectorBucketPolicy` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.getVectorBucketPolicy(crossinline block: GetVectorBucketPolicyRequest.Builder.() -> Unit): GetVectorBucketPolicyResponse = getVectorBucketPolicy(GetVectorBucketPolicyRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Returns vector attributes. To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:GetVectors` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.getVectors(crossinline block: GetVectorsRequest.Builder.() -> Unit): GetVectorsResponse = getVectors(GetVectorsRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Returns a list of all the vector indexes within the specified vector bucket. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:ListIndexes` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.listIndexes(crossinline block: ListIndexesRequest.Builder.() -> Unit): ListIndexesResponse = listIndexes(ListIndexesRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Returns a list of all the vector buckets that are owned by the authenticated sender of the request.
 *
 * ## Permissions
 * You must have the `s3vectors:ListVectorBuckets` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.listVectorBuckets(crossinline block: ListVectorBucketsRequest.Builder.() -> Unit): ListVectorBucketsResponse = listVectorBuckets(ListVectorBucketsRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * List vectors in the specified vector index. To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
 *
 * `ListVectors` operations proceed sequentially; however, for faster performance on a large number of vectors in a vector index, applications can request a parallel `ListVectors` operation by providing the `segmentCount` and `segmentIndex` parameters.
 *
 * ## Permissions
 * You must have the `s3vectors:ListVectors` permission to use this operation. Additional permissions are required based on the request parameters you specify:
 * + With only `s3vectors:ListVectors` permission, you can list vector keys when `returnData` and `returnMetadata` are both set to false or not specified..
 * + If you set `returnData` or `returnMetadata` to true, you must have both `s3vectors:ListVectors` and `s3vectors:GetVectors` permissions. The request fails with a `403 Forbidden` error if you request vector data or metadata without the `s3vectors:GetVectors` permission.
 */
public suspend inline fun S3VectorsClient.listVectors(crossinline block: ListVectorsRequest.Builder.() -> Unit): ListVectorsResponse = listVectors(ListVectorsRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Creates a bucket policy for a vector bucket. To specify the bucket, you must use either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:PutVectorBucketPolicy` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.putVectorBucketPolicy(crossinline block: PutVectorBucketPolicyRequest.Builder.() -> Unit): PutVectorBucketPolicyResponse = putVectorBucketPolicy(PutVectorBucketPolicyRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Adds one or more vectors to a vector index. To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
 *
 * For more information about limits, see [Limitations and restrictions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html) in the *Amazon S3 User Guide*.
 *
 * When inserting vector data into your vector index, you must provide the vector data as `float32` (32-bit floating point) values. If you pass higher-precision values to an Amazon Web Services SDK, S3 Vectors converts the values to 32-bit floating point before storing them, and `GetVectors`, `ListVectors`, and `QueryVectors` operations return the float32 values. Different Amazon Web Services SDKs may have different default numeric types, so ensure your vectors are properly formatted as `float32` values regardless of which SDK you're using. For example, in Python, use `numpy.float32` or explicitly cast your values.
 *
 * ## Permissions
 * You must have the `s3vectors:PutVectors` permission to use this operation.
 */
public suspend inline fun S3VectorsClient.putVectors(crossinline block: PutVectorsRequest.Builder.() -> Unit): PutVectorsResponse = putVectors(PutVectorsRequest.Builder().apply(block).build())

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * Performs an approximate nearest neighbor search query in a vector index using a query vector. By default, it returns the keys of approximate nearest neighbors. You can optionally include the computed distance (between the query vector and each vector in the response), the vector data, and metadata of each vector in the response.
 *
 * To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
 *
 * ## Permissions
 * You must have the `s3vectors:QueryVectors` permission to use this operation. Additional permissions are required based on the request parameters you specify:
 * + With only `s3vectors:QueryVectors` permission, you can retrieve vector keys of approximate nearest neighbors and computed distances between these vectors. This permission is sufficient only when you don't set any metadata filters and don't request vector data or metadata (by keeping the `returnMetadata` parameter set to `false` or not specified).
 * + If you specify a metadata filter or set `returnMetadata` to true, you must have both `s3vectors:QueryVectors` and `s3vectors:GetVectors` permissions. The request fails with a `403 Forbidden error` if you request metadata filtering, vector data, or metadata without the `s3vectors:GetVectors` permission.
 */
public suspend inline fun S3VectorsClient.queryVectors(crossinline block: QueryVectorsRequest.Builder.() -> Unit): QueryVectorsResponse = queryVectors(QueryVectorsRequest.Builder().apply(block).build())
