// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.content.Document

public class QueryVectorsRequest private constructor(builder: Builder) {
    /**
     * Metadata filter to apply during the query. For more information about metadata keys, see [Metadata filtering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-metadata-filtering.html) in the *Amazon S3 User Guide*.
     */
    public val filter: aws.smithy.kotlin.runtime.content.Document? = builder.filter
    /**
     * The ARN of the vector index that you want to query.
     */
    public val indexArn: kotlin.String? = builder.indexArn
    /**
     * The name of the vector index that you want to query.
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * The query vector. Ensure that the query vector has the same dimension as the dimension of the vector index that's being queried. For example, if your vector index contains vectors with 384 dimensions, your query vector must also have 384 dimensions.
     */
    public val queryVector: aws.sdk.kotlin.services.s3vectors.model.VectorData? = builder.queryVector
    /**
     * Indicates whether to include the computed distance in the response. The default value is `false`.
     */
    public val returnDistance: kotlin.Boolean? = builder.returnDistance
    /**
     * Indicates whether to include metadata in the response. The default value is `false`.
     */
    public val returnMetadata: kotlin.Boolean? = builder.returnMetadata
    /**
     * The number of results to return for each query.
     */
    public val topK: kotlin.Int? = builder.topK
    /**
     * The name of the vector bucket that contains the vector index.
     */
    public val vectorBucketName: kotlin.String? = builder.vectorBucketName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3vectors.model.QueryVectorsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryVectorsRequest(")
        append("filter=$filter,")
        append("indexArn=$indexArn,")
        append("indexName=$indexName,")
        append("queryVector=$queryVector,")
        append("returnDistance=$returnDistance,")
        append("returnMetadata=$returnMetadata,")
        append("topK=$topK,")
        append("vectorBucketName=$vectorBucketName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (indexArn?.hashCode() ?: 0)
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (queryVector?.hashCode() ?: 0)
        result = 31 * result + (returnDistance?.hashCode() ?: 0)
        result = 31 * result + (returnMetadata?.hashCode() ?: 0)
        result = 31 * result + (topK ?: 0)
        result = 31 * result + (vectorBucketName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryVectorsRequest

        if (filter != other.filter) return false
        if (indexArn != other.indexArn) return false
        if (indexName != other.indexName) return false
        if (queryVector != other.queryVector) return false
        if (returnDistance != other.returnDistance) return false
        if (returnMetadata != other.returnMetadata) return false
        if (topK != other.topK) return false
        if (vectorBucketName != other.vectorBucketName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3vectors.model.QueryVectorsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Metadata filter to apply during the query. For more information about metadata keys, see [Metadata filtering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-metadata-filtering.html) in the *Amazon S3 User Guide*.
         */
        public var filter: aws.smithy.kotlin.runtime.content.Document? = null
        /**
         * The ARN of the vector index that you want to query.
         */
        public var indexArn: kotlin.String? = null
        /**
         * The name of the vector index that you want to query.
         */
        public var indexName: kotlin.String? = null
        /**
         * The query vector. Ensure that the query vector has the same dimension as the dimension of the vector index that's being queried. For example, if your vector index contains vectors with 384 dimensions, your query vector must also have 384 dimensions.
         */
        public var queryVector: aws.sdk.kotlin.services.s3vectors.model.VectorData? = null
        /**
         * Indicates whether to include the computed distance in the response. The default value is `false`.
         */
        public var returnDistance: kotlin.Boolean? = null
        /**
         * Indicates whether to include metadata in the response. The default value is `false`.
         */
        public var returnMetadata: kotlin.Boolean? = null
        /**
         * The number of results to return for each query.
         */
        public var topK: kotlin.Int? = null
        /**
         * The name of the vector bucket that contains the vector index.
         */
        public var vectorBucketName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3vectors.model.QueryVectorsRequest) : this() {
            this.filter = x.filter
            this.indexArn = x.indexArn
            this.indexName = x.indexName
            this.queryVector = x.queryVector
            this.returnDistance = x.returnDistance
            this.returnMetadata = x.returnMetadata
            this.topK = x.topK
            this.vectorBucketName = x.vectorBucketName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3vectors.model.QueryVectorsRequest = QueryVectorsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
