// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 *
 * The attributes of a vector index.
 */
public class Index private constructor(builder: Builder) {
    /**
     * Date and time when the vector index was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The data type of the vectors inserted into the vector index.
     */
    public val dataType: aws.sdk.kotlin.services.s3vectors.model.DataType = requireNotNull(builder.dataType) { "A non-null value must be provided for dataType" }
    /**
     * The number of values in the vectors that are inserted into the vector index.
     */
    public val dimension: kotlin.Int = requireNotNull(builder.dimension) { "A non-null value must be provided for dimension" }
    /**
     * The distance metric to be used for similarity search.
     */
    public val distanceMetric: aws.sdk.kotlin.services.s3vectors.model.DistanceMetric = requireNotNull(builder.distanceMetric) { "A non-null value must be provided for distanceMetric" }
    /**
     * The Amazon Resource Name (ARN) of the vector index.
     */
    public val indexArn: kotlin.String = requireNotNull(builder.indexArn) { "A non-null value must be provided for indexArn" }
    /**
     * The name of the vector index.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The metadata configuration for the vector index.
     */
    public val metadataConfiguration: aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration? = builder.metadataConfiguration
    /**
     * The name of the vector bucket that contains the vector index.
     */
    public val vectorBucketName: kotlin.String = requireNotNull(builder.vectorBucketName) { "A non-null value must be provided for vectorBucketName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3vectors.model.Index = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Index(")
        append("creationTime=$creationTime,")
        append("dataType=$dataType,")
        append("dimension=$dimension,")
        append("distanceMetric=$distanceMetric,")
        append("indexArn=$indexArn,")
        append("indexName=$indexName,")
        append("metadataConfiguration=$metadataConfiguration,")
        append("vectorBucketName=$vectorBucketName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (dataType.hashCode())
        result = 31 * result + (dimension)
        result = 31 * result + (distanceMetric.hashCode())
        result = 31 * result + (indexArn.hashCode())
        result = 31 * result + (indexName.hashCode())
        result = 31 * result + (metadataConfiguration?.hashCode() ?: 0)
        result = 31 * result + (vectorBucketName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Index

        if (creationTime != other.creationTime) return false
        if (dataType != other.dataType) return false
        if (dimension != other.dimension) return false
        if (distanceMetric != other.distanceMetric) return false
        if (indexArn != other.indexArn) return false
        if (indexName != other.indexName) return false
        if (metadataConfiguration != other.metadataConfiguration) return false
        if (vectorBucketName != other.vectorBucketName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3vectors.model.Index = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Date and time when the vector index was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data type of the vectors inserted into the vector index.
         */
        public var dataType: aws.sdk.kotlin.services.s3vectors.model.DataType? = null
        /**
         * The number of values in the vectors that are inserted into the vector index.
         */
        public var dimension: kotlin.Int? = null
        /**
         * The distance metric to be used for similarity search.
         */
        public var distanceMetric: aws.sdk.kotlin.services.s3vectors.model.DistanceMetric? = null
        /**
         * The Amazon Resource Name (ARN) of the vector index.
         */
        public var indexArn: kotlin.String? = null
        /**
         * The name of the vector index.
         */
        public var indexName: kotlin.String? = null
        /**
         * The metadata configuration for the vector index.
         */
        public var metadataConfiguration: aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration? = null
        /**
         * The name of the vector bucket that contains the vector index.
         */
        public var vectorBucketName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3vectors.model.Index) : this() {
            this.creationTime = x.creationTime
            this.dataType = x.dataType
            this.dimension = x.dimension
            this.distanceMetric = x.distanceMetric
            this.indexArn = x.indexArn
            this.indexName = x.indexName
            this.metadataConfiguration = x.metadataConfiguration
            this.vectorBucketName = x.vectorBucketName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3vectors.model.Index = Index(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration] inside the given [block]
         */
        public fun metadataConfiguration(block: aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration.Builder.() -> kotlin.Unit) {
            this.metadataConfiguration = aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (dataType == null) dataType = DataType.SdkUnknown("no value provided")
            if (dimension == null) dimension = 0
            if (distanceMetric == null) distanceMetric = DistanceMetric.SdkUnknown("no value provided")
            if (indexArn == null) indexArn = ""
            if (indexName == null) indexName = ""
            if (vectorBucketName == null) vectorBucketName = ""
            return this
        }
    }
}
