// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateIndexRequest private constructor(builder: Builder) {
    /**
     * The data type of the vectors to be inserted into the vector index.
     */
    public val dataType: aws.sdk.kotlin.services.s3vectors.model.DataType? = builder.dataType
    /**
     * The dimensions of the vectors to be inserted into the vector index.
     */
    public val dimension: kotlin.Int? = builder.dimension
    /**
     * The distance metric to be used for similarity search.
     */
    public val distanceMetric: aws.sdk.kotlin.services.s3vectors.model.DistanceMetric? = builder.distanceMetric
    /**
     * The name of the vector index to create.
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * The metadata configuration for the vector index.
     */
    public val metadataConfiguration: aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration? = builder.metadataConfiguration
    /**
     * The Amazon Resource Name (ARN) of the vector bucket to create the vector index in.
     */
    public val vectorBucketArn: kotlin.String? = builder.vectorBucketArn
    /**
     * The name of the vector bucket to create the vector index in.
     */
    public val vectorBucketName: kotlin.String? = builder.vectorBucketName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3vectors.model.CreateIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIndexRequest(")
        append("dataType=$dataType,")
        append("dimension=$dimension,")
        append("distanceMetric=$distanceMetric,")
        append("indexName=$indexName,")
        append("metadataConfiguration=$metadataConfiguration,")
        append("vectorBucketArn=$vectorBucketArn,")
        append("vectorBucketName=$vectorBucketName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataType?.hashCode() ?: 0
        result = 31 * result + (dimension ?: 0)
        result = 31 * result + (distanceMetric?.hashCode() ?: 0)
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (metadataConfiguration?.hashCode() ?: 0)
        result = 31 * result + (vectorBucketArn?.hashCode() ?: 0)
        result = 31 * result + (vectorBucketName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIndexRequest

        if (dataType != other.dataType) return false
        if (dimension != other.dimension) return false
        if (distanceMetric != other.distanceMetric) return false
        if (indexName != other.indexName) return false
        if (metadataConfiguration != other.metadataConfiguration) return false
        if (vectorBucketArn != other.vectorBucketArn) return false
        if (vectorBucketName != other.vectorBucketName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3vectors.model.CreateIndexRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The data type of the vectors to be inserted into the vector index.
         */
        public var dataType: aws.sdk.kotlin.services.s3vectors.model.DataType? = null
        /**
         * The dimensions of the vectors to be inserted into the vector index.
         */
        public var dimension: kotlin.Int? = null
        /**
         * The distance metric to be used for similarity search.
         */
        public var distanceMetric: aws.sdk.kotlin.services.s3vectors.model.DistanceMetric? = null
        /**
         * The name of the vector index to create.
         */
        public var indexName: kotlin.String? = null
        /**
         * The metadata configuration for the vector index.
         */
        public var metadataConfiguration: aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the vector bucket to create the vector index in.
         */
        public var vectorBucketArn: kotlin.String? = null
        /**
         * The name of the vector bucket to create the vector index in.
         */
        public var vectorBucketName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3vectors.model.CreateIndexRequest) : this() {
            this.dataType = x.dataType
            this.dimension = x.dimension
            this.distanceMetric = x.distanceMetric
            this.indexName = x.indexName
            this.metadataConfiguration = x.metadataConfiguration
            this.vectorBucketArn = x.vectorBucketArn
            this.vectorBucketName = x.vectorBucketName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3vectors.model.CreateIndexRequest = CreateIndexRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration] inside the given [block]
         */
        public fun metadataConfiguration(block: aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration.Builder.() -> kotlin.Unit) {
            this.metadataConfiguration = aws.sdk.kotlin.services.s3vectors.model.MetadataConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
