// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3vectors.serde

import aws.sdk.kotlin.services.s3vectors.model.QueryVectorsRequest
import aws.sdk.kotlin.services.s3vectors.model.VectorData
import aws.smithy.kotlin.runtime.content.Document
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class QueryVectorsOperationSerializer: HttpSerializer.NonStreaming<QueryVectorsRequest> {
    override fun serialize(context: ExecutionContext, input: QueryVectorsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/QueryVectors"
        }

        val payload = serializeQueryVectorsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeQueryVectorsOperationBody(context: ExecutionContext, input: QueryVectorsRequest): ByteArray {
    val serializer = JsonSerializer()
    val FILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Document, JsonSerialName("filter"))
    val INDEXARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexArn"))
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexName"))
    val QUERYVECTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("queryVector"))
    val RETURNDISTANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("returnDistance"))
    val RETURNMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("returnMetadata"))
    val TOPK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("topK"))
    val VECTORBUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vectorBucketName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILTER_DESCRIPTOR)
        field(INDEXARN_DESCRIPTOR)
        field(INDEXNAME_DESCRIPTOR)
        field(QUERYVECTOR_DESCRIPTOR)
        field(RETURNDISTANCE_DESCRIPTOR)
        field(RETURNMETADATA_DESCRIPTOR)
        field(TOPK_DESCRIPTOR)
        field(VECTORBUCKETNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.filter?.let { field(FILTER_DESCRIPTOR, it) }
        input.indexArn?.let { field(INDEXARN_DESCRIPTOR, it) }
        input.indexName?.let { field(INDEXNAME_DESCRIPTOR, it) }
        input.queryVector?.let { field(QUERYVECTOR_DESCRIPTOR, it, ::serializeVectorDataDocument) }
        input.returnDistance?.let { field(RETURNDISTANCE_DESCRIPTOR, it) }
        input.returnMetadata?.let { field(RETURNMETADATA_DESCRIPTOR, it) }
        input.topK?.let { field(TOPK_DESCRIPTOR, it) }
        input.vectorBucketName?.let { field(VECTORBUCKETNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
